/*****************************************************************************************
*
* \file       dia_ISWUpdatePrjListener.h
*
*******************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ__
#include "dia_ISWUpdatePrj.h"
#endif

#ifndef IID_SWUPDATE_PRJ_LISTENER
#define IID_SWUPDATE_PRJ_LISTENER                 ((dia::IID) 0x523999a4) // {b0aa173b-c124-477d-9ece-06b823e8a333}
#endif

/**
 *
 *  \class dia_ISWUpdatePrjListener
 *
 */

enum dia_eSWUpdatePrjError
{
   DIA_EN_UPDATE_PRJ_ERROR_DEFAULT_SWL_OK = 0,
   DIA_EN_UPDATE_PRJ_ERROR_INCOMPATIBLE_STICK,
   DIA_EN_UPDATE_PRJ_ERROR_UNAVAILABLE_STICK,
   DIA_EN_UPDATE_PRJ_ERROR_REMOVED_STICK,
   DIA_EN_UPDATE_PRJ_ERROR_DOWNGRADE_STICK,
   DIA_EN_UPDATE_PRJ_ERROR_SAMEGRADE_STICK,
   DIA_EN_UPDATE_PRJ_ERROR_INCOMPATIBLE_USB_FORMAT
};

enum dia_eSourceType
{
   DIA_EN_UPDATE_PRJ_SOURCETYPE_USB = 0,
   DIA_EN_UPDATE_PRJ_SOURCETYPE_SD,
   DIA_EN_UPDATE_PRJ_SOURCETYPE_OTA,
   DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER
};

enum dia_eUpdateState
{
   DIA_EN_UPDATE_PRJ_UPDATESTATE_IDLE = 0,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_NOTREADY,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_SELECTSOURCE,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_SELECTRELEASE,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_CONFIG,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_RUNNING,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_ERROR,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_SKIPPING,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_ABORTING,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_RESULT,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_REBOOT,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_WAITALLOWRECOVERYMODE,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_MEDIUMREMOVED,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_PRERESULT,
   DIA_EN_UPDATE_PRJ_UPDATESTATE_READY
};

enum dia_eUpdOptions
{
   DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWONLY = 0,
   DIA_EN_UPDATE_PRJ_UPDATEOPTION_DIFFERENTONLY,
   DIA_EN_UPDATE_PRJ_UPDATEOPTION_ANY,
   DIA_EN_UPDATE_PRJ_UPDATEOPTION_USERDEFINED,
   DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWANDSAMEONLY
};

enum dia_eUpdDirection
{
   DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UPGRADE = 0,
   DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_SAME,
   DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_DOWNGRADE,
   DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UNKNOWN
};

struct dia_tReleaseDocInfo
{
public:
   std::string mReleaseName;
   bool mNeedFlashing;
   tU32 mEstimatedTime;
   dia_eUpdOptions mFilterOption;
   dia_eUpdDirection mUpdateDirection;
   dia_eSourceType mSourceType;
};


class dia_ISWUpdatePrjListener
      : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_SWUPDATE_PRJ_LISTENER)
   //   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

   public:
   virtual void vOnUpdateErrors(dia_eSWUpdatePrjError eError,bool vCheck) = 0;
   virtual void vOnAbortStatus(bool bUpdateAbortResponse) = 0;
   virtual void vOnUpdateReleaseFilterStatus(tU32 updateSetReleaseFilterResponse) = 0;
protected:
   //! virtual base class destructor
   virtual ~dia_ISWUpdatePrjListener ( void ) {}
};

/**
 *
 *  \class dia_ISWUpdatePrjListenerImpl
 *
 */

class dia_ISWUpdatePrjListenerImpl
      : public dia_ISWUpdatePrjListener
{
public:
   virtual void vOnUpdateErrors(dia_eSWUpdatePrjError eError,bool vCheck) {}
   virtual void vOnAbortStatus(bool bUpdateAbortResponse) {}
   virtual void vOnUpdateReleaseFilterStatus(tU32 updateSetReleaseFilterResponse) {}
protected:
   //! virtual base class destructor
   virtual ~dia_ISWUpdatePrjListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_ISWUpdatePrjNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISWUpdatePrjNotifier
      : public dia_ISWUpdatePrjListener,
      public dia_Notifier<dia_ISWUpdatePrjListener>
{
public:

   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnUpdateErrors,dia_eSWUpdatePrjError,bool)
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnAbortStatus,bool)
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnUpdateReleaseFilterStatus,tU32)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ_LISTENER__ */
