/*****************************************************************************************
*
* \file       dia_ISWUpdatePrj.h
*
*****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ__
#define __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

#ifndef IID_SWUPDATE_PRJ
#define IID_SWUPDATE_PRJ                          ((dia::IID) 0xf7cf5417) // {0a885ed6-d84b-4018-bad8-282fe50b16e9}
#endif

//------------------------------------------------------------------------------

class dia_ISWUpdatePrj
{
   DIA_DECL_INTERFACE_IID(IID_SWUPDATE_PRJ)
   //   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

   public:

   virtual tDiaResult getUpdateState ( tVoid ) = 0;

   virtual tDiaResult getReleaseDoc ( tVoid ) = 0;

   virtual tDiaResult getUpdateErrors ( tVoid ) = 0;

   virtual tDiaResult getUpdateOptionsInfo ( tVoid ) = 0;
   virtual tDiaResult SetSoftwareUpdateType(tU8 updateType) = 0;

   virtual tDiaResult getUpdateProgress ( tVoid ) = 0;

   virtual tDiaResult setAllowRecoveryModeRequest(bool flag) = 0;
   virtual tDiaResult handleStartDownloadRequest() = 0;
   virtual tDiaResult sendAbortRequest() = 0;
   virtual tDiaResult SetReleaseFilter() = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISWUpdatePrj ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ__*/

