/*
 * dia_ISWControlListener.h
 *
 *  Created on: 07.12.2015
 *      Author: stc2hi
 *--------------------------------------------------------------------------------------------------------------------
 * NCG3D-44304      | 2.0	| NLK1KOR (RBEI  )	| Implemented PIVI-4292 Communication (connection) status
 *--------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_INTERFACE_SWC_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SWC_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SWC__
#include "dia_ISWControl.h"
#endif

//-----------------------------------------------------------------------------
class dia_SWCConnectionInfo
{
public:
    //! class constructor
    dia_SWCConnectionInfo ( void )
    {
		m_AbsentState = 0xff;
		m_connectionStatus = 0x00;
    }
    //! class destructor
    ~dia_SWCConnectionInfo ( void ) {}

    //! check if the given ECU is absent
    tU8 getAbsentState ( ) const { return m_AbsentState; }
    //! check if the given ECU is absent
    tU8 getConnectionState ( ) const { return m_connectionStatus; }
	//! set absent mode for the given ECU
    void setAbsentState ( tU8 absentState ) { m_AbsentState = absentState; }
	//! set Connection Status for the given SWC
    void setConnectionState ( tU8 connectionState ) { m_connectionStatus = connectionState; }

protected:
    //! absent mode for the set of given ECUs
    tU8 m_AbsentState;
	//! connection state for SWC
    tU8 m_connectionStatus;
};

//-----------------------------------------------------------------------------

class dia_ISWControlListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_SWC_LISTENER)

public:
    //! notify the SWC status
    virtual void vOnSWCConnectionInfo ( const dia_SWCConnectionInfo& ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_ISWControlListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ISWControlListenerImpl
    : public dia_ISWControlListener
{
public:
    //! notify connection state of SWC
    virtual void vOnSWCConnectionInfo ( const dia_SWCConnectionInfo& ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_ISWControlListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ISWControlNotifier
    : public dia_ISWControlListener,
      public dia_Notifier<dia_ISWControlListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSWCConnectionInfo, const dia_SWCConnectionInfo&)
};


#endif /* __INCLUDED_DIA_INTERFACE_SWC_LISTENER__ */
