/*****************************************************************************************
*
* \file       dia_IPhoneConnectionSettingListener.h
*
* \brief      listener of dia_IPhoneConnectionSettingListener
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       02 June 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING_LISTENER__
#define __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING__
#include "dia_IPhoneConnectionSetting.h"
#endif

/**
 *
 *  \class dia_IPhoneConnectionSettingListener
 *
 */

class dia_IPhoneConnectionSettingListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_PHONE_CONNECTION_SETTING_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response to getPhoneConnectionEstablishmentDuration
   virtual void vOnPhoneConnectionEstablishmentDurationStatus ( tU32 duration ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IPhoneConnectionSettingListener ( void ) {}
};

/**
 *
 *  \class dia_IPhoneConnectionSettingListenerImpl
 *
 */

class dia_IPhoneConnectionSettingListenerImpl
   : public dia_IPhoneConnectionSettingListener
{
public:
   //! response to getPhoneConnectionEstablishmentDuration
   virtual void vOnPhoneConnectionEstablishmentDurationStatus ( tU32 /*duration*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IPhoneConnectionSettingListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IPhoneConnectionSettingNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IPhoneConnectionSettingNotifier
   : public dia_IPhoneConnectionSettingListener,
     public dia_Notifier<dia_IPhoneConnectionSettingListener>
{
public:
   //! response to getPhoneConnectionEstablishmentDuration
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnPhoneConnectionEstablishmentDurationStatus,tU32)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING_LISTENER__ */

