/*****************************************************************************************
*
* \file    dia_IPIVIInputHandling.h
*
* \brief   interface of dia_IPIVIInputHandling
*
* The interface-class covers methods for sending requests and data to SAFeature. The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author  nlk1kor (generated with dia_igen tool)
*
* \date    06 June 2017
*
* (c) 2017 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING__
#define __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

class dia_IPIVIInputHandling
{
   DIA_DECL_INTERFACE_IID(IID_PIVI_INPUT_HANDLING)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! returns touch position and touch status
   virtual tDiaResult getTouchPIVISecondaryInfo ( void  ) = 0;
   //! set simulated PIVI Single touch.
   virtual tDiaResult setPIVITouchIntern ( const tU16 u16X, const tU16 u16Y, const tU16 u16ScreenNumber, const dia_eInputHandlingTouchInfoPrj eTouchInfo ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IPIVIInputHandling ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING__ */

