/*
 * dia_INissanVCanInfoListener.h
 *
 *  Created on: 10.01.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_VCAN__
#define __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_VCAN__

#ifndef __INCLUDED_DIA_INTERFACE_NISSANVCANINFO__
#include "dia_INissanVCanInfo.h"
#endif

//-----------------------------------------------------------------------------

class dia_NissanVCanInfo
{
public:
    //! class constructor
    dia_NissanVCanInfo ( tU32 numECUs )
    {
       m_diagBytes.resize(numECUs, 0xff);
    }
    //! class destructor
    ~dia_NissanVCanInfo ( void )
    {
       m_diagBytes.clear();
    }

// new Fi support
public:
    //! get diag byte for the given ECU
    tU8 getDiagByte ( tU8 ecu) const { return m_diagBytes[ecu]; }
    //! set diag byte for the given ECU
    void setDiagByte ( tU8 ecu, tU8 diagByte ) { m_diagBytes[ecu] = diagByte; }
protected:
    //! diag bytes for the set of given ECUs
    std::vector<tU8> m_diagBytes;
};

//-----------------------------------------------------------------------------

class dia_INissanVCanInfoListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_SYSADAPTER_NISSAN_VCAN_INFO_LISTENER)

public:
    //! request the network status
    virtual void vOnVCanInfo ( const dia_NissanVCanInfo& ) = 0;
    //! request the network status
    virtual void vOnVCanInfo ( const std::list<tU8>& deviceInfoList ) = 0;
    //! On receiving the current state of the CSM signal HandBrake.
    virtual void vOnVCanCsmHandBrakeInfo ( const tBool csmHandBrakeData, const tU32 csmHandBrakeState ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_INissanVCanInfoListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_NissanVCanInfoListenerImpl
    : public dia_INissanVCanInfoListener
{
public:
    //! adjust audio settings
    virtual void vOnVCanInfo ( const dia_NissanVCanInfo& ) {}
    //! request the network status
    virtual void vOnVCanInfo ( const std::list<tU8>& ) {};
    //! On receiving the current state of the CSM signal HandBrake.
    virtual void vOnVCanCsmHandBrakeInfo ( const tBool csmHandBrakeData, const tU32 csmHandBrakeState ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_NissanVCanInfoListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_NissanVCanInfoNotifier
    : public dia_INissanVCanInfoListener,
      public dia_Notifier<dia_INissanVCanInfoListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnVCanInfo, const dia_NissanVCanInfo&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnVCanInfo, const std::list<tU8>&)
    DIA_M_ADD_NOTIFIER_TWO_ARG(vOnVCanCsmHandBrakeInfo, const tBool, const tU32)
};


#endif /* __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_VCAN__ */
