/*
 * dia_INissanMCanInfoListener.h
 *
 *  Created on: 10.01.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_MCAN__
#define __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_MCAN__

#ifndef DIA_INISSANMCANINFO_H_
#include "dia_INissanMCanInfo.h"
#endif

//-----------------------------------------------------------------------------

enum dia_enNissanECUMCAN
{
    DIA_EN_NISSAN_ECU_MCAN_UNKNOWN = 0,
    DIA_EN_NISSAN_ECU_MCAN_SWC,
    DIA_EN_NISSAN_ECU_MCAN_AUD,
    DIA_EN_NISSAN_ECU_MCAN_NAV,
    DIA_EN_NISSAN_ECU_MCAN_NAV_GEN2,
    DIA_EN_NISSAN_ECU_MCAN_TCU,
    DIA_EN_NISSAN_ECU_MCAN_BOSE,
    DIA_EN_NISSAN_ECU_MCAN_RSE,
    DIA_EN_NISSAN_ECU_MCAN_COUNT
};

//-----------------------------------------------------------------------------

class dia_NissanMCanInfo
{
public:
    //! class constructor
    dia_NissanMCanInfo ( void )
    {
        for ( int i=0; i<DIA_EN_NISSAN_ECU_MCAN_COUNT; ++i ) 
		{
			m_AbsentState[i] = 0xff;
		}
    }
    //! class destructor
    ~dia_NissanMCanInfo ( void ) {}

    //! check if the given ECU is absent
    tU8 u8AbsentState ( dia_enNissanECUMCAN ecu ) const { return m_AbsentState[ecu]; }

	//! set absent mode for the given ECU
    void setAbsentState ( dia_enNissanECUMCAN ecu, tU8 absentState ) { m_AbsentState[ecu] = absentState; }

protected:
    //! absent mode for the set of given ECUs
    tU8 m_AbsentState[DIA_EN_NISSAN_ECU_MCAN_COUNT];
};

//-----------------------------------------------------------------------------
class dia_NissanMCanTransmissionStatus
{
public:
    //! class constructor
    dia_NissanMCanTransmissionStatus ( void )
    {
        for ( int i=0; i<DIA_EN_NISSAN_ECU_MCAN_COUNT; ++i ) 
		{
			m_MPDTMuteState[i] = 0xff;
		}
    }
    //! class destructor
    ~dia_NissanMCanTransmissionStatus ( void ) {}

    //! check if the given ECU is absent
    tU8 u8MPDTMuteState ( dia_enNissanECUMCAN ecu ) const { return m_MPDTMuteState[ecu]; }

	//! set absent mode for the given ECU
    void setMPDTMuteState ( dia_enNissanECUMCAN ecu, tU8 muteState ) { m_MPDTMuteState[ecu] = muteState; }

protected:
    //! absent mode for the set of given ECUs
    tU8 m_MPDTMuteState[DIA_EN_NISSAN_ECU_MCAN_COUNT];
};


//-----------------------------------------------------------------------------

class dia_INissanMCanInfoListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_NISSAN_MCAN_INFO_LISTENER)

public:
    //! notify the network status
    virtual void vOnMCanInfo ( const dia_NissanMCanInfo& ) = 0;
    //! notify the transmission status
    virtual void vOnMCanTransmissionStatus ( const dia_NissanMCanTransmissionStatus& ) = 0;
	//! delivers information about the connected devices
	virtual void vOnMCanMeterInfo(const std::vector<dia_meterMCANInfo> MCANMeterInfo) = 0;
protected:
    //! virtual base class destructor
    virtual ~dia_INissanMCanInfoListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_NissanMCanInfoListenerImpl
    : public dia_INissanMCanInfoListener
{
public:
    //! notify connection state of ECUs connected to the MCAN
    virtual void vOnMCanInfo ( const dia_NissanMCanInfo& ) {}
    //! notify the transmission status
    virtual void vOnMCanTransmissionStatus ( const dia_NissanMCanTransmissionStatus& ) {}
	//! delivers information about the connected devices
	virtual void vOnMCanMeterInfo(const std::vector<dia_meterMCANInfo> /*MCANMeterInfo*/) {}
protected:
    //! virtual base class destructor
    virtual ~dia_NissanMCanInfoListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_NissanMCanInfoNotifier
    : public dia_INissanMCanInfoListener,
      public dia_Notifier<dia_INissanMCanInfoListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnMCanInfo,const dia_NissanMCanInfo&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnMCanTransmissionStatus,const dia_NissanMCanTransmissionStatus&)
	//! delivers information about the connected devices
	DIA_M_ADD_NOTIFIER_ONE_ARG(vOnMCanMeterInfo, const std::vector<dia_meterMCANInfo>)
};


#endif /* __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_MCAN__ */
