/*
 * dia_INissanMCanInfo.h
 *
 *  Created on: 17.03.2011
 *      Author: gib2hi
 */

#ifndef DIA_INISSANMCANINFO_H_
#define DIA_INISSANMCANINFO_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif
enum dia_enNissanMCAN
{
	DIA_EN_NISSAN_MCAN_UNKNOWN = 0,
	DIA_EN_NISSAN_MCAN_SWC,
	DIA_EN_NISSAN_MCAN_AUD,
	DIA_EN_NISSAN_MCAN_NAV,
	DIA_EN_NISSAN_MCAN_COUNT
};

struct dia_meterMCANInfo
{
public:
	//! default constructor
	dia_meterMCANInfo(void)
		: McanDeviceType(DIA_EN_NISSAN_MCAN_UNKNOWN),
		McanConnectionState(0)
	{}

	//! copy constructor
	dia_meterMCANInfo(const dia_meterMCANInfo& obj)
		: McanDeviceType(obj.McanDeviceType),
		McanConnectionState(obj.McanConnectionState)
	{}

	//! assignment operator
	dia_meterMCANInfo& operator = (const dia_meterMCANInfo& obj)
	{
		if (this != &obj) {
			McanDeviceType = obj.McanDeviceType;
			McanConnectionState = obj.McanConnectionState;
		}
		return *this;
	}

	//! class constructor
	dia_meterMCANInfo(
		dia_enNissanMCAN srv,
		tU8 dev
		)
		: McanDeviceType(srv),
		McanConnectionState(dev)
	{}

public:
	dia_enNissanMCAN McanDeviceType;
	tU8 McanConnectionState;
};
class dia_INissanMCanInfo
{
    DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_NISSAN_MCAN_INFO)

public:
    //! request the network status
    virtual tDiaResult getNissanMCANInfo ( void ) = 0;
    //! request the transmission status
    virtual tDiaResult getNissanMCANTransmissionStatus ( void ) = 0;
	//! get meter mcan connection status
	virtual tDiaResult getNissanMCANMeterInfo(void) = 0;
protected:
    //! virtual base class destructor
    virtual ~dia_INissanMCanInfo (void) {}
};

#endif /* DIA_INISSANMCANINFO_H_ */
