/*****************************************************************************************
* \file    dia_INissanLanguage.h
*
* \brief   interface of dia_INissanLanguage
*
* The interface-class covers methods for sending requests and data to SAFeature. The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author  shw2abt (generated with dia_igen tool)
*
* \date    06 November 2014
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE__
#define __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eNissanLanguage
{
   DIA_EN_NISSAN_LANGUAGE_UNKNOWN = 0,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH,
   DIA_EN_NISSAN_LANGUAGE_GERMAN,
   DIA_EN_NISSAN_LANGUAGE_PORTUGESE,
   DIA_EN_NISSAN_LANGUAGE_CHINESE,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_US,
   DIA_EN_NISSAN_LANGUAGE_ALBANESE,
   DIA_EN_NISSAN_LANGUAGE_ARABIC,
   DIA_EN_NISSAN_LANGUAGE_BULGARIAN,
   DIA_EN_NISSAN_LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED_CHINESE_CHARACTER,
   DIA_EN_NISSAN_LANGUAGE_CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER,
   DIA_EN_NISSAN_LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER,
   DIA_EN_NISSAN_LANGUAGE_CROATIAN,
   DIA_EN_NISSAN_LANGUAGE_CZECH,
   DIA_EN_NISSAN_LANGUAGE_DANISH,
   DIA_EN_NISSAN_LANGUAGE_DUTCH,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_AUSTRALIAN,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_UK,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_US_FOR_JPN,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_US_FOR_PRC,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_CANADIAN,
   DIA_EN_NISSAN_LANGUAGE_ENGLISH_INDIA,
   DIA_EN_NISSAN_LANGUAGE_ESTONIAN,
   DIA_EN_NISSAN_LANGUAGE_FINNISH,
   DIA_EN_NISSAN_LANGUAGE_FLEMISH,
   DIA_EN_NISSAN_LANGUAGE_FRENCH,
   DIA_EN_NISSAN_LANGUAGE_FRENCH_CANADIAN,
   DIA_EN_NISSAN_LANGUAGE_GREEK,
   DIA_EN_NISSAN_LANGUAGE_HEBREW,
   DIA_EN_NISSAN_LANGUAGE_HINDI,
   DIA_EN_NISSAN_LANGUAGE_HUNGARIAN,
   DIA_EN_NISSAN_LANGUAGE_INDONESIAN,
   DIA_EN_NISSAN_LANGUAGE_ITALIAN,
   DIA_EN_NISSAN_LANGUAGE_JAPANESE,
   DIA_EN_NISSAN_LANGUAGE_KOREAN,
   DIA_EN_NISSAN_LANGUAGE_LATVIAN,
   DIA_EN_NISSAN_LANGUAGE_LITHUANIAN,
   DIA_EN_NISSAN_LANGUAGE_MALAY,
   DIA_EN_NISSAN_LANGUAGE_NORWEGIAN,
   DIA_EN_NISSAN_LANGUAGE_PERSIAN_FARSI_IRANIAN,
   DIA_EN_NISSAN_LANGUAGE_PHILIPPINES,
   DIA_EN_NISSAN_LANGUAGE_POLISH,
   DIA_EN_NISSAN_LANGUAGE_PORTUGUESE,
   DIA_EN_NISSAN_LANGUAGE_PORTUGUESE_BRAZILIAN,
   DIA_EN_NISSAN_LANGUAGE_ROMANIAN,
   DIA_EN_NISSAN_LANGUAGE_RUSSIAN,
   DIA_EN_NISSAN_LANGUAGE_SERBIAN,
   DIA_EN_NISSAN_LANGUAGE_SLOVAKIAN,
   DIA_EN_NISSAN_LANGUAGE_SLOVENIAN,
   DIA_EN_NISSAN_LANGUAGE_SPANISH,
   DIA_EN_NISSAN_LANGUAGE_SPANISH_LATIN_AMERICAN,
   DIA_EN_NISSAN_LANGUAGE_SPANISH_MEXICAN,
   DIA_EN_NISSAN_LANGUAGE_SWEDISH,
   DIA_EN_NISSAN_LANGUAGE_TAIWANESE,
   DIA_EN_NISSAN_LANGUAGE_THAI,
   DIA_EN_NISSAN_LANGUAGE_TURKISH,
   DIA_EN_NISSAN_LANGUAGE_UKRAINIAN,
   DIA_EN_NISSAN_LANGUAGE_VIETNAMESE,   
   DIA_EN_NISSAN_LANGUAGE_COUNT
};


//------------------------------------------------------------------------------

class dia_INissanLanguage
{
   DIA_DECL_INTERFACE_IID(IID_NISSAN_LANGUAGE)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! set new hmi language
   virtual tDiaResult setHMILanguage ( dia_eNissanLanguage u8Country ) = 0;
   //! read current hmi language
   virtual tDiaResult getHMILanguage ( void  ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_INissanLanguage ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE__ */

