/*
 * dia_INissanBusStateListener.h
 *
 *  Created on: 10.01.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_BUS_STATE__
#define __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_BUS_STATE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/depricated/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//-----------------------------------------------------------------------------

enum dia_enNissanBusType
{
    DIA_EN_NISSAN_BUS_UNKNOWN = 0,
    DIA_EN_NISSAN_BUS_MCAN,
    DIA_EN_NISSAN_BUS_VCAN,
    DIA_EN_NISSAN_MUTE_MCAN,
    DIA_EN_NISSAN_MUTE_VCAN,
    DIA_EN_NISSAN_BUS_COUNT
};

class dia_NissanBusState
{
public:
    //! class constructor
    dia_NissanBusState ( tU32 numMCanECUs )
    {
        for ( int i=0; i<DIA_EN_NISSAN_BUS_COUNT; ++i )
        {
            m_BusOff[i]  = FALSE;
            m_BusMute[i] = FALSE;
            m_diagBytes[i] = 0xff;
        }
        m_MCanMuteState.resize(numMCanECUs, 0xff);
    }
    //! class destructor
    ~dia_NissanBusState ( void )
    {
       m_MCanMuteState.clear();
    }

    tBool bIsBusOff ( const dia_enNissanBusType& busID ) const { return m_BusOff[busID]; }
    //! set bus off mode
    void setBusOffMode ( const dia_enNissanBusType& busID, tBool busMode ) { m_BusOff[busID] = busMode; }

    tBool bIsBusMuted ( const dia_enNissanBusType& busID ) const { return m_BusMute[busID]; }
    //! set bus off mode
    void setBusMuteMode ( const dia_enNissanBusType& busID, tBool busMode ) { m_BusMute[busID] = busMode; }

protected:
    //! bus off state
    tBool m_BusOff[DIA_EN_NISSAN_BUS_COUNT];
    //! bus mute state
    tBool m_BusMute[DIA_EN_NISSAN_BUS_COUNT];
// new Fi support
public:
    //! get diag byte for the given bus type
    tU8 getDiagByte ( dia_enNissanBusType bus) const { return m_diagBytes[bus]; }
    //! set diag byte for the given bus type
    void setDiagByte ( dia_enNissanBusType bus, tU8 diagByte ) { m_diagBytes[bus] = diagByte; }
    //! get mcan mute state for the given ecu type
    tU8 getMCanMuteState ( tU8 ecu) const { return m_MCanMuteState[ecu]; }
    //! set mcan mute state for the given ecu type
    void setMCanMuteState ( tU8 ecu, tU8 muteState ) { m_MCanMuteState[ecu] = muteState; }
protected:
    //! diag bytes for the set of given buses
    tU8 m_diagBytes[DIA_EN_NISSAN_BUS_COUNT];
    //! diag bytes for mcan mute ecus
    std::vector<tU8> m_MCanMuteState;
};

//-----------------------------------------------------------------------------

class dia_INissanBusStateListener
   : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_NISSAN_BUS_STATE_LISTENER)

public:
    //! notify network bus status
    virtual void vOnBusStateInfo ( const dia_NissanBusState& ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_INissanBusStateListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_NissanBusStateListenerImpl
    : public dia_INissanBusStateListener
{
public:
    //! notify network bus status
    virtual void vOnBusStateInfo ( const dia_NissanBusState& ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_NissanBusStateListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_NissanBusStateNotifier
    : public dia_INissanBusStateListener,
      public dia_Notifier<dia_INissanBusStateListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnBusStateInfo,const dia_NissanBusState&)
};


#endif /* __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_BUS_STATE__ */
