/*****************************************************************************************
*
* \file       dia_IMediaFileCounterListener.h
*
* \brief      Definition of the listener interface to the media file counter feature
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     aoo2kor (generated with dia_igen tool)
*
* \date       13 Sept 2021
*
* \copyright  (c) 2020 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER_LISTENER__
#define __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER__
#include "dia_IMediaFileCounter.h"
#endif

#ifndef IID_MEDIA_FILE_COUNTER_PRJ_LISTENER
#define IID_MEDIA_FILE_COUNTER_PRJ_LISTENER                 ((dia::IID) 0x3de30fe5) // {d410f4ba-0732-4ccb-8fe9-75bafa99e71e}   
#endif

/*
 *
 *  class dia_IMediaFileCounterListener
 *
 */

class dia_IMediaFileCounterListener
      : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_MEDIA_FILE_COUNTER_PRJ_LISTENER)
   //   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

   public:
      //! result on the vOnVideoFile_noOfFilesCounter_Get call
      virtual void vOnVideoFile_noOfFilesCounter_Get ( tU32 videoFileCounter ) = 0;
	  //! result on the vOnAudioFile_noOfFilesCounter_Get call
      virtual void vOnAudioFile_noOfFilesCounter_Get ( tU32 audioFileCounter ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IMediaFileCounterListener ( void ) {}
};

/**
 *
 *  \class dia_IMediaFileCounterListenerImpl
 *
 */

class dia_IMediaFileCounterListenerImpl
      : public dia_IMediaFileCounterListener
{
public:
   //! result on the vOnVideoFile_noOfFilesCounter_Get call
   virtual void vOnVideoFile_noOfFilesCounter_Get ( tU32 /*videoFileCounter*/ ) {}
   //! result on the vOnAudioFile_noOfFilesCounter_Get call
   virtual void vOnAudioFile_noOfFilesCounter_Get ( tU32 /*audioFileCounter*/ ) {}


protected:
   //! virtual base class destructor
   virtual ~dia_IMediaFileCounterListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IMediaFileCounterNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IMediaFileCounterNotifier
      : public dia_IMediaFileCounterListener,
      public dia_Notifier<dia_IMediaFileCounterListener>
{
public:
   //! result on the vOnVideoFile_noOfFilesCounter_Get call
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnVideoFile_noOfFilesCounter_Get,tU32)
   //! result on the vOnAudioFile_noOfFilesCounter_Get call
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnAudioFile_noOfFilesCounter_Get,tU32)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER_LISTENER__ */

