/*****************************************************************************************
*
* \file       dia_IInputHandlingPrjListener.h
*
* \brief      Definition of the listener interface to the InputHandling feature
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     mky6kor (generated with dia_igen tool)
*
* \date       09 July 2018
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
* 09/07/2018	| bma9kor	| Modified the file name
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__
#define __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ__
#include "dia_IInputHandlingPrj.h"
#endif

struct dia_tTouchPressHistoryInfoPrj
{
public:
	dia_eInputHandlingTouchInfoPrj mType;
	tS32 mXCoord;
	tS32 mYCoord;
	tS32 mXDelta;
	tS32 mYDelta;
};

struct dia_tEncoderDirHistoryInfoPrj
{
public:
	tU8 mType;
	tS8 mSteps;

};

struct dia_tPressedKeyPrj
{
public:
   //! default constructor
   dia_tPressedKeyPrj ( void )
      : mCode(DIA_PRJ_KEY_CODE_UNKNOWN),
        mStatus(0)
   {}

   //! class constructor
   dia_tPressedKeyPrj (
         dia_eVdInuptHandlingKeyCodePrj keyCode,
         tU8 keyStatus
      )
      : mCode(keyCode),
        mStatus(keyStatus)
   {}

public:
   dia_eVdInuptHandlingKeyCodePrj mCode;
   tU8 mStatus;
};

/**
 *
 *  \class dia_IInputHandlingPrjListener
 *
 */

class dia_IInputHandlingPrjListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_INPUT_HANDLING_PRJ_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey ( const std::vector<tU8> pressedKeys ) = 0;
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey ( const std::vector<dia_tPressedKeyPrj> pressedKeys ) = 0;
   //! reply on getting/setting encoder status
   virtual void vOnEncoderStatus ( const std::vector<tU8> vecEncoderStatus ) = 0;
   //! reply on getting/setting encoder direction status
   virtual void vOnEncoderDirStatus ( const std::vector<tS8> vecEncoderDirStatus ) = 0;
   //! reply on the status of touch screen
   virtual void vOnTouchInfo ( const tU16 u16X, const tU16 u16Y, const tU16 u16DeltaX, const tU16 u16DeltaY, const dia_eInputHandlingTouchInfoPrj eTouchInfo ) = 0;
   //! reply on simulating key press or key release on the operating unit
   virtual void vOnSetKey ( const tDiaResult eDiaResult ) = 0;
   //! reply on locking the operating unit
   virtual void vOnLockControlUnit ( const tDiaResult eDiaResult ) = 0;
   //! reply on starting the touch panel calibration
   virtual void vOnTouchPanelAlignmentDone ( const tDiaResult eDiaResult ) = 0;
   //! reply on starting the input event simulation (requirement from VD_Input)
   virtual void vOnEnableInputEvents ( const tBool bSimulationStatus ) = 0;
   //! Error handling function in pressed key simulation
   virtual void vOnGetPressedKeyError ( void ) = 0;
   //! Error handling function for touch panel status
   virtual void vOnTouchInfoError ( void  ) = 0;
   //! reply on simulating touch press or release on HMI screen
   virtual void vOnSetTouch ( const tDiaResult eDiaResult ) = 0;
   //! reply on simulating touch slide on HMI screen
   virtual void vOnSetTouchSlide ( const tDiaResult eDiaResult ) = 0;
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture ( const tDiaResult eDiaResult ) = 0;
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture ( const tDiaResult eDiaResult ) = 0;
   //! reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnTouchInfohistory ( const std::vector<dia_tTouchPressHistoryInfoPrj> vecTouchPressInfo ) = 0;
   //! reply on Encoder Dir history : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnEncoderDirHistory ( const std::vector<dia_tEncoderDirHistoryInfoPrj> vecEncoderDirInfo ) = 0;
   //! reply on getting/setting encoder status
   virtual void vOnSetEncoder ( const tDiaResult eDiaResult ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IInputHandlingPrjListener ( void ) {}
};

/**
 *
 *  \class dia_IInputHandlingPrjListenerImpl
 *
 */

class dia_IInputHandlingPrjListenerImpl
   : public dia_IInputHandlingPrjListener
{
public:
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey ( const std::vector<tU8> /*pressedKeys*/ ) {}
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey ( const std::vector<dia_tPressedKeyPrj> /*pressedKeys*/ ) {}
   //! reply on getting/setting encoder status
   virtual void vOnEncoderStatus ( const std::vector<tU8> /*vecEncoderStatus*/ ) {}
   //! reply on getting/setting encoder direction status
   virtual void vOnEncoderDirStatus ( const std::vector<tS8> /*vecEncoderDirStatus*/ ) {}
   //! reply on the status of touch screen
   virtual void vOnTouchInfo ( const tU16 /*u16X*/, const tU16 /*u16Y*/, const tU16 /*u16DeltaX*/, const tU16 /*u16DeltaY*/, const dia_eInputHandlingTouchInfoPrj /*eTouchInfo*/ ) {}
   //! reply on simulating key press or key release on the operating unit
   virtual void vOnSetKey ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on locking the operating unit
   virtual void vOnLockControlUnit ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on starting the touch panel calibration
   virtual void vOnTouchPanelAlignmentDone ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on starting the input event simulation (requirement from VD_Input)
   virtual void vOnEnableInputEvents ( const tBool /*bSimulationStatus*/ ) {}
   //! Error handling function in pressed key simulation
   virtual void vOnGetPressedKeyError ( void /**/ ) {}
   //! Error handling function for touch panel status
   virtual void vOnTouchInfoError ( void /**/ ) {}
   //! reply on simulating touch press or release on HMI screen
   virtual void vOnSetTouch ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on simulating touch slide on HMI screen
   virtual void vOnSetTouchSlide ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnTouchInfohistory ( const std::vector<dia_tTouchPressHistoryInfoPrj> /*vecTouchPressInfo*/ ) {}
   //! reply on Encoder Dir history : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnEncoderDirHistory ( const std::vector<dia_tEncoderDirHistoryInfoPrj> /*vecEncoderDirInfo*/ ) {}
   //! reply on getting/setting encoder status
   virtual void vOnSetEncoder ( const tDiaResult /*eDiaResult*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IInputHandlingPrjListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IInputHandlingPrjNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IInputHandlingPrjNotifier
   : public dia_IInputHandlingPrjListener,
     public dia_Notifier<dia_IInputHandlingPrjListener>
{
public:
   //! reply on getting last pressed key
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnGetPressedKey,const std::vector<tU8>)
   //! reply on getting last pressed key
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnGetPressedKey,const std::vector<dia_tPressedKeyPrj>)
   //! reply on getting/setting encoder status
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnEncoderStatus,const std::vector<tU8>)
   //! reply on getting/setting encoder direction status
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnEncoderDirStatus,const std::vector<tS8>)
   //! reply on the status of touch screen
   DIA_M_ADD_NOTIFIER_FIVE_ARG(vOnTouchInfo,const tU16,const tU16,const tU16,const tU16,const dia_eInputHandlingTouchInfoPrj)
   //! reply on simulating key press or key release on the operating unit
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetKey,const tDiaResult)
   //! reply on locking the operating unit
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnLockControlUnit,const tDiaResult)
   //! reply on starting the touch panel calibration
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnTouchPanelAlignmentDone,const tDiaResult)
   //! reply on starting the input event simulation (requirement from VD_Input)
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnEnableInputEvents,const tBool)
   //! Error handling function in pressed key simulation
   DIA_M_ADD_NOTIFIER_NO_ARG(vOnGetPressedKeyError)
   //! Error handling function for touch panel status
   DIA_M_ADD_NOTIFIER_NO_ARG(vOnTouchInfoError)
   //! reply on simulating touch press or release on HMI screen
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetTouch,const tDiaResult)
   //! reply on simulating touch slide on HMI screen
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetTouchSlide,const tDiaResult)
   //! reply on recording the gesture in file system
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnRecordGesture,const tDiaResult)
   //! reply on replaying the gesture saved in file system
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReplayGesture,const tDiaResult)
   //! reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnTouchInfohistory,const std::vector<dia_tTouchPressHistoryInfoPrj>)
   //! reply on Encoder Dir history : implemented to recieve a list of operations for Monitoring and Calibration feature.
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnEncoderDirHistory,const std::vector<dia_tEncoderDirHistoryInfoPrj>)
   //! reply on getting/setting encoder status
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetEncoder,const tDiaResult)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__ */

