/*
 * dia_IITCommanderListener.h
 *
 *  Created on: 30.06.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_IT_COMMANDER_LISTENER__
#define __INCLUDED_DIA_INTERFACE_IT_COMMANDER_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_IT_COMMANDER__
#include "dia_IITCommander.h"
#endif

//-----------------------------------------------------------------------------

class dia_ITCommanderConnectionInfo
{
public:
    //! class constructor
    dia_ITCommanderConnectionInfo ( void )
    {
		m_AbsentState = 0xff;
    }
    //! class destructor
    ~dia_ITCommanderConnectionInfo ( void ) {}

    //! check if the given ECU is absent
    tU8 getAbsentState ( ) const { return m_AbsentState; }

	//! set absent mode for the given ECU
    void setAbsentState ( tU8 absentState ) { m_AbsentState = absentState; }

protected:
    //! absent mode for the set of given ECUs
    tU8 m_AbsentState;
};

//-----------------------------------------------------------------------------

class dia_IITCommanderListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_IT_COMMANDER_LISTENER)

public:
    //! notify the network status
    virtual void vOnConnectionInfo ( const dia_ITCommanderConnectionInfo& ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_IITCommanderListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ITCommanderListenerImpl
    : public dia_IITCommanderListener
{
public:
    //! notify connection state of ECUs connected to the MCAN
    virtual void vOnConnectionInfo ( const dia_ITCommanderConnectionInfo& ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_ITCommanderListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ITCommanderNotifier
    : public dia_IITCommanderListener,
      public dia_Notifier<dia_IITCommanderListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectionInfo,const dia_ITCommanderConnectionInfo&)
};


#endif /* __INCLUDED_DIA_INTERFACE_IT_COMMANDER_LISTENER__ */
