/*****************************************************************************************
*
* \file       dia_IHMINavigationListener.h
*
* \brief      listener of dia_IHMINavigationListener
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       17 May 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
/*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 09.02.2017		| 1.1	| NLK1KOR (RBEI)	|  AIVI-28703 Worker class for the Sensor simulation via sensor log file

*******************************************************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION_LISTENER__
#define __INCLUDED_DIA_INTERFACE_HMINAVIGATION_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION__
#include "dia_IHMINavigation.h"
#endif

/**
 *
 *  \class dia_IHMINavigationListener
 *
 */
enum dia_TripReplayStatus
   {
      DIA_EN_UNKNOWN = 0,
      DIA_EN_RESERVED,
      DIA_EN_NOT_ACTIVE,
      DIA_EN_ACTIVE,
      DIA_EN_FILE_NOT_FOUND_ERROR,
      DIA_EN_INTERNAL_ERROR
   };
class dia_IHMINavigationListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_HMI_NAVIGATION_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response to getRouteCalculationDuration and registerToRouteCalculationDuration methods
   virtual void vOnRouteCalculationDuration ( tU32 routeCalDurationToFinalDest, tU32 routeCalDurationToNextDest ) = 0;

   virtual void vOnStartTripFileReplayResponse(tDiaResult eDiaResult) = 0;
   virtual void vOnStopTripFileReplayResponse(tDiaResult eDiaResult) = 0;
   //! response to SendStopTripFileReplayStatusInforequest 
   virtual void vOnTripReplayStatusInfoUpdate(dia_TripReplayStatus status) = 0;

   virtual void vOnDataSetVersionStatus(const std::string& dataSetVersion) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHMINavigationListener ( void ) {}
};

/**
 *
 *  \class dia_IHMINavigationListenerImpl
 *
 */

class dia_IHMINavigationListenerImpl
   : public dia_IHMINavigationListener
{
public:
   //! response to getRouteCalculationDuration and registerToRouteCalculationDuration methods
   virtual void vOnRouteCalculationDuration ( tU32 /*routeCalDurationToFinalDest*/, tU32 /*routeCalDurationToNextDest*/ ) {}
   //! response to SendStartTripFileReplayrequest 
   virtual void vOnStartTripFileReplayResponse(tDiaResult eDiaResult) {}
   //! response to SendStopTripFileReplayrequest 
   virtual void vOnStopTripFileReplayResponse(tDiaResult eDiaResult) {}
      //! response to SendStopTripFileReplayStatusInforequest 
   virtual void vOnTripReplayStatusInfoUpdate(dia_TripReplayStatus status) {}
   //! response to getDatasetVersion and registerToDatasetVersion methods
   virtual void vOnDataSetVersionStatus(const std::string& dataSetVersion) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IHMINavigationListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IHMINavigationNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IHMINavigationNotifier
   : public dia_IHMINavigationListener,
     public dia_Notifier<dia_IHMINavigationListener>
{
public:
   //! response to getRouteCalculationDuration and registerToRouteCalculationDuration methods
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnRouteCalculationDuration,tU32,tU32)
   //! response to SendStartTripFileReplayrequest 
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnStartTripFileReplayResponse,tDiaResult)
   //! response to SendStopTripFileReplayrequest 
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnStopTripFileReplayResponse,tDiaResult)
   //! response to SendStopTripFileReplayStatusInforequest 
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnTripReplayStatusInfoUpdate,dia_TripReplayStatus)
   //! response to getDatasetVersion and registerToDatasetVersion methods
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnDataSetVersionStatus,const std::string&)

};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_HMINAVIGATION_LISTENER__ */

