/*****************************************************************************************
*
* \file       dia_IHMINavigationDataUpdateListener.h
*
* \brief      listener of dia_IHMINavigationDataUpdateListener
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     kaa1hi (generated with dia_igen tool)
*
* \date       28 March 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE__
#include "dia_IHMINavigationDataUpdate.h"
#endif

/**
 *
 *  \class dia_IHMINavigationDataUpdateListener
 *
 */

class dia_IHMINavigationDataUpdateListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_HMI_NAVIGATION_DATA_UPDATE_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response to getNavDataUpdateStatus methods
   virtual void vOnGetNavDataUpdateStatus ( tU8 progress, dia_eMapUpdateStatus updateStatus ) = 0;
   //! response to performFullUpdateViaUSB methods
   virtual void vOnPerformFullUpdateViaUSB ( dia_eFullUpdateViaUSBConfirmation ack ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHMINavigationDataUpdateListener ( void ) {}
};

/**
 *
 *  \class dia_IHMINavigationDataUpdateListenerImpl
 *
 */

class dia_IHMINavigationDataUpdateListenerImpl
   : public dia_IHMINavigationDataUpdateListener
{
public:
   //! response to getNavDataUpdateStatus methods
   virtual void vOnGetNavDataUpdateStatus ( tU8 /*progress*/, dia_eMapUpdateStatus /*updateStatus*/ ) {}
   //! response to performFullUpdateViaUSB methods
   virtual void vOnPerformFullUpdateViaUSB ( dia_eFullUpdateViaUSBConfirmation /*ack*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IHMINavigationDataUpdateListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IHMINavigationDataUpdateNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IHMINavigationDataUpdateNotifier
   : public dia_IHMINavigationDataUpdateListener,
     public dia_Notifier<dia_IHMINavigationDataUpdateListener>
{
public:
   //! response to getNavDataUpdateStatus methods
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnGetNavDataUpdateStatus,tU8,dia_eMapUpdateStatus)
   //! response to performFullUpdateViaUSB methods
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnPerformFullUpdateViaUSB,dia_eFullUpdateViaUSBConfirmation)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE_LISTENER__ */

