/*****************************************************************************************
*
* \file       dia_IHMINavigationDataUpdate.h
*
* \brief      interface of dia_IHMINavigationDataUpdate
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     kaa1hi (generated with dia_igen tool)
*
* \date       28 March 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE__
#define __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eFullUpdateViaUSBConfirmation
{
   DIA_EN_FULL_UPDATE_CONFIRMATION_UNKNOWN = 0,
   DIA_EN_FULL_UPDATE_CONFIRMATION_ACCEPTED,
   DIA_EN_FULL_UPDATE_CONFIRMATION_DECLINED_CANNOT_PROCESS,
   DIA_EN_FULL_UPDATE_CONFIRMATION_DECLINED_REQUEST_ACTIVE,
   DIA_EN_FULL_UPDATE_CONFIRMATION_COUNT
};

//------------------------------------------------------------------------------

enum dia_eMapUpdateStatus
{
   DIA_EN_MAP_UPDATE_STATUS_UNKNOWN = 0,
   DIA_EN_MAP_UPDATE_STATUS_COMPLETED_OK,
   DIA_EN_MAP_UPDATE_STATUS_COMPLETED_NOK,
   DIA_EN_MAP_UPDATE_STATUS_ABORTED,
   DIA_EN_MAP_UPDATE_STATUS_RUNNING,
   DIA_EN_MAP_UPDATE_STATUS_STOPPED,
   DIA_EN_MAP_UPDATE_STATUS_NOT_RUN,
   DIA_EN_MAP_UPDATE_STATUS_COUNT
};

//------------------------------------------------------------------------------

class dia_IHMINavigationDataUpdate
{
   DIA_DECL_INTERFACE_IID(IID_HMI_NAVIGATION_DATA_UPDATE)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! trigger performing of Full Update of NAVI Map via USB
   virtual tDiaResult performFullUpdateViaUSB ( void ) = 0;
   //! get status of Navigation data update (status, progressValue, remainingTime)
   virtual tDiaResult getNavDataUpdateStatus ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHMINavigationDataUpdate ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE__ */

