/*****************************************************************************************
*
* \file       dia_IHMIMonitor.h
*
* \brief      interface of dia_IHMIMonitor
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       16 March 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HMIMONITOR__
#define __INCLUDED_DIA_INTERFACE_HMIMONITOR__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

//------------------------------------------------------------------------------

class dia_IHMIMonitor
{
   DIA_DECL_INTERFACE_IID(IID_HMI_MONITOR)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! retrieve the active screen/popup on foreground of Upper Screen
   virtual tDiaResult getActiveForegroundSceneUpper ( void ) = 0;
   //! retrieve the active screen/popup on foreground
   virtual tDiaResult getHMIActiveForegroundScene ( void ) = 0;
   //! retrieve the startup time interval till OEM logo in ms
   virtual tDiaResult getHMIStartUpTimeInterval ( void ) = 0;
   //! register to the property for the current active rendered view name of Upper Screen
   virtual tDiaResult registerToActiveRenderedUpperViewName ( void ) = 0;
   //! register to the property for the current active rendered view name
   virtual tDiaResult registerToActiveRenderedViewName ( void ) = 0;
   //! register to the property for the next active app name
   virtual tDiaResult registerToNextActiveAppUpper ( void ) = 0;
   //! register to the property for the next active app name
   virtual tDiaResult registerToNextActiveAppLower ( void ) = 0;
   //! register to the property for the next active app name
   virtual tDiaResult getNextActiveForegroundSceneLower ( void ) = 0;
   //! register to the property for the next active app name
   virtual tDiaResult getNextActiveForegroundSceneUpper ( void ) = 0;
   //! register to the property for the next active app name
   virtual tDiaResult setHMIMonitorInfoServiceStatus ( tU8 status ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHMIMonitor ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_HMIMONITOR__ */

