/*****************************************************************************************
*
* \file       dia_IErrorLogASFListener.h
*
* \brief      Listener interface for the ErrorLog (diaglog) component ASF interface
*
* This interface is used to deliver results for asynchronous services requested via the dia_IErrorLogASF interface
*
* \author     gpu2kor (generated with dia_igen tool)
*
* \date       07 December 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOGASF_LISTENER__
#define __INCLUDED_DIA_INTERFACE_ERRORLOGASF_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOGASF__
#include "dia_IErrorLogASF.h"
#endif

/**
 *
 *  \class dia_IErrorLogASFListener
 *
 */

class dia_IErrorLogASFListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_ERRORLOGASF_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response function for clear DTC request
   virtual void vOnClearDTCResp ( tU8 status ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLogASFListener ( void ) {}
};

/**
 *
 *  \class dia_IErrorLogASFListenerImpl
 *
 */

class dia_IErrorLogASFListenerImpl
   : public dia_IErrorLogASFListener
{
public:
   //! response function for clear DTC request
   virtual void vOnClearDTCResp ( tU8 /*status*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLogASFListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IErrorLogASFNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IErrorLogASFNotifier
   : public dia_IErrorLogASFListener,
     public dia_Notifier<dia_IErrorLogASFListener>
{
public:
   //! response function for clear DTC request
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnClearDTCResp,tU8)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_ERRORLOGASF_LISTENER__ */

