/*****************************************************************************************
*
* \file       dia_ICVBSConnectionListener.h
*
* \brief      Definition of the listener interface to the cvbs connection feature
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     ama8kor (generated with dia_igen tool)
*
* \date       12 June 2020
*
* \copyright  (c) 2020 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_CVBSCONNECTION_LISTENER__
#define __INCLUDED_DIA_INTERFACE_CVBSCONNECTION_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_CVBSCONNECTION__
#include "dia_ICVBSConnection.h"
#endif

/**
 *
 *  \class dia_ICVBSConnectionListener
 *
 */

class dia_ICVBSConnectionListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_CVBS_CONNECTION_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! reply on getting current cvbs connection status
   virtual void vOnCVBSConnectionStatus ( const dia_eCVBSConnectionInfo status ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ICVBSConnectionListener ( void ) {}
};

/**
 *
 *  \class dia_ICVBSConnectionListenerImpl
 *
 */

class dia_ICVBSConnectionListenerImpl
   : public dia_ICVBSConnectionListener
{
public:
   //! reply on getting current cvbs connection status
   virtual void vOnCVBSConnectionStatus ( const dia_eCVBSConnectionInfo /*status*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ICVBSConnectionListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_ICVBSConnectionNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ICVBSConnectionNotifier
   : public dia_ICVBSConnectionListener,
     public dia_Notifier<dia_ICVBSConnectionListener>
{
public:
   //! reply on getting current cvbs connection status
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnCVBSConnectionStatus,const dia_eCVBSConnectionInfo)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_CVBSCONNECTION_LISTENER__ */

