/*****************************************************************************************
*
* \file    dia_IBluetoothMost.h
*
* \brief   Listener interface for the bluetooth - most component
*
* This interface is used to deliver results for services requested via the dia_IBluetoothMost interface
*
* \author  nce5kor	
*
* \date    02.12.2015
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
*
* -------------------------------------------------------
* Date           | Author             | Modification
* 28-12-2015     | nce5kor			  | Added the interfaces for BTSignalQuality
* 13-01-2017     | jas1hi			  | Extended the struct dia_tBTExtendedDeviceInfo with btDevDisconnectedReason
* 7.7.17         | mky6kor            | Updated Num of BT devices from 5 to 6.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST__
#define __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eBTDeviceDisconnectedReason
{
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_NOT_APPLICABLE          = 0,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_DEVICE_REQUEST          = 1,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_MODULE_REQUEST          = 2,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_AUTOMATIC               = 3,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_OUT_OF_RANGE            = 4,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_INTERMEDIATE            = 5,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_CONNECT_TIMEOUT         = 10,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_CONNECT_REJECTED        = 11,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_PROTOCOL_NOT_SUPPORTED  = 12,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_CONNECT_FAILED          = 13,
	DIA_EN_BTDEVICE_DISCONNECTED_REASON_COUNT
};

//------------------------------------------------------------------------------

struct dia_tBTExtendedDeviceInfo
{
public:
   //! default constructor
   dia_tBTExtendedDeviceInfo ( void )
      : btDevAddr(0),
        btDevName(0),
	    btDevConnectionStatus(0),
	    btDevDisconnectedReason (DIA_EN_BTDEVICE_DISCONNECTED_REASON_NOT_APPLICABLE)
   {}

   //! copy constructor
   dia_tBTExtendedDeviceInfo ( const dia_tBTExtendedDeviceInfo& obj )
      : btDevAddr(obj.btDevAddr),
        btDevName(obj.btDevName),
		btDevConnectionStatus(obj.btDevConnectionStatus),
		btDevDisconnectedReason(obj.btDevDisconnectedReason)
		
   {}

   //! assignment operator
   dia_tBTExtendedDeviceInfo& operator = ( const dia_tBTExtendedDeviceInfo& obj )
   {
      if ( this != &obj ) {
         btDevAddr = obj.btDevAddr;
         btDevName = obj.btDevName;
		 btDevConnectionStatus = obj.btDevConnectionStatus;
		 btDevDisconnectedReason = obj.btDevDisconnectedReason;
      }
      return *this;
   }

   //! class constructor
   dia_tBTExtendedDeviceInfo (
         tString addr, 
         tString name,
		 tU8     connectionStatus,
		 dia_eBTDeviceDisconnectedReason     disconnectedReason
      )
      : btDevAddr(addr),
        btDevName(name),
		btDevConnectionStatus(connectionStatus),
		btDevDisconnectedReason(disconnectedReason)
   {}

public:
   tString                         btDevAddr;
   tString                         btDevName;
   tBool                           btDevConnectionStatus;
   dia_eBTDeviceDisconnectedReason btDevDisconnectedReason; // Identifies the reason for the disconnected phone
};

//------------------------------------------------------------------------------

#define MAX_BT_DEVICE_COUNT ((tU8) 6)

//------------------------------------------------------------------------------

class dia_IBluetoothMost
{
   DIA_DECL_INTERFACE_IID(IID_SYSADAPTER_BLUETOOTH_MOST)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! get connected Bluetooth devices
   virtual tDiaResult getBTMostDeviceList ( void  ) = 0;
   //! get signal strength of connected Bluetooth devices
   virtual tDiaResult getBTSignalQuality ( void  ) = 0;
   
   //! get BT Connection status
//#ifdef VARIANT_S_FTR_ENABLE_RIVIE 
   virtual tDiaResult registerToBTConnectionStatus(void) = 0;
//#endif   
   

protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothMost ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_BLUETOOTH__ */

