/*****************************************************************************************
*
* \file    dia_IBluetoothListener.h
*
* \brief   Listener interface for the bluetooth component
*
* This interface is used to deliver results for asynchronous services requested via the dia_IBluetooth interface
*
* \author  shw2abt (generated with dia_igen tool)
*
* \date    05 September 2014
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
* -------------------------------------------------------
* Date           | Author             | Modification
* 28-12-2015     | nce5kor			  | Commented the code for customer bt signal quality.
										New CCA implementation will be provided with next release.
* 15-01-2016     | nce5kor			  |	added new listener calls for Customer specific read Wifi and BT address service handlers.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#define __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH__
#include "dia_IBluetooth.h"
#endif

#ifndef IID_SYSADAPTER_BLUETOOTH_LISTENER
#define IID_SYSADAPTER_BLUETOOTH_LISTENER ((dia::IID) 0x31760437)
#endif

/**
 *
 *  \class dia_IBluetoothListener
 *
 */

class dia_IBluetoothListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_SYSADAPTER_BLUETOOTH_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! notification of the current BT mode
   virtual void vOnBTModeStatus ( dia_eBTMode mode ) = 0;
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTModeRequestACK ( tBool result ) = 0;
   /**
    * \brief   */
   virtual void vOnReadMacAddressResult ( const tU8* const pu8Result ) = 0;
   /**
    * \brief   */
   virtual void vOnReadMacAddressError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnReadWifiMacAddressResult ( const tU8* const pu8Result ) = 0;
   /**
    * \brief   */
   virtual void vOnReadWifiMacAddressError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnReadCustBTMacAddressResult ( const tU8* const pu8Result ) = 0;
   /**
    * \brief   */
   virtual void vOnReadCustBTMacAddressError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnReadCustWifiMacAddressResult ( const tU8* const pu8Result ) = 0;
   /**
    * \brief   */
   virtual void vOnReadCustWifiMacAddressError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnReadBDAddressResult ( const tU8* const pu8Result ) = 0;
   /**
    * \brief   */
   virtual void vOnReadBDAddressError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnBDFieldstrengthResult ( const tU8 u8LinkQuality, const tU8 u8Fieldstrength ) = 0;
   /**
    * \brief   */
   virtual void vOnBDFieldstrengthError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnWifiFieldstrengthResult ( const tU8 u8LinkQuality, const tU8 u8Fieldstrength ) = 0;
   /**
    * \brief   */
   virtual void vOnWifiFieldstrengthError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnConnectionControlResult ( const tU32 u32Result ) = 0;
   /**
    * \brief   */
   virtual void vOnConnectionControlResult ( const tU8 u8Result, const tU8 u8ConnectionStatus ) = 0;
   /**
    * \brief   */
   virtual void vOnConnectionControlError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnConnectedDeviceStatusResult ( const tU8 u8Device, const tU8* const pu8Result ) = 0;
   /**
    * \brief   */
   virtual void vOnConnectedDeviceStatusError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnDeviceLinkQualityResult ( const tU8 u8Device, tU8 u8LinkQuality ) = 0;
   /**
    * \brief   */
   virtual void vOnDeviceLinkQualityError ( const tU32 errCode ) = 0;
   /**
    * \brief   */
   virtual void vOnAuthenticatedDevicesPresentResult ( const tU8 u8Devices ) = 0;
   /**
    * \brief   */
   virtual void vOnAuthenticatedDevicesPresentError ( const tU32 errCode ) = 0;
   //! Signal to inform requester about success of the "BT link quality" request
//   virtual void vOnCustBTLinkQualityResult ( tU8 errorRate, tU8 linkQuality ) = 0;
   //! Signal to inform requester about failure of the "BT link quality" request
 //  virtual void vOnCustBTLinkQualityError ( tDiaResult result ) = 0;
   //! forwards any errors on the Bluetooth interface
   virtual void vOnBT_SigQ_RSSIError ( const tU32 errCode ) = 0;
   //! delivers the Bluetooth signal strength info
   virtual void vOnBT_SigQ_RSSI ( const  tU8 u8SigQ, tU8 u8RSSI ) = 0;
protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothListener ( void ) {}
};

/**
 *
 *  \class dia_IBluetoothListenerImpl
 *
 */

class dia_IBluetoothListenerImpl
   : public dia_IBluetoothListener
{
public:
   //! notification of the current BT mode
   virtual void vOnBTModeStatus ( dia_eBTMode /*mode*/ ) {}
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTModeRequestACK ( tBool /*result*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadMacAddressResult ( const tU8* const /*pu8Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadMacAddressError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadWifiMacAddressResult ( const tU8* const /*pu8Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadWifiMacAddressError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadCustBTMacAddressResult ( const tU8* const /*pu8Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadCustBTMacAddressError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadCustWifiMacAddressResult ( const tU8* const /*pu8Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadCustWifiMacAddressError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadBDAddressResult ( const tU8* const /*pu8Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnReadBDAddressError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnBDFieldstrengthResult ( const tU8 /*u8LinkQuality*/, const tU8 /*u8Fieldstrength*/ ) {}
   /**
    * \brief   */
   virtual void vOnBDFieldstrengthError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnWifiFieldstrengthResult ( const tU8 /*u8LinkQuality*/, const tU8 /*u8Fieldstrength*/ ) {}
   /**
    * \brief   */
   virtual void vOnWifiFieldstrengthError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnConnectionControlResult ( const tU32 /*u32Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnConnectionControlResult ( const tU8 /*u8Result*/, const tU8 /*u8ConnectionStatus*/ ) {}
   /**
    * \brief   */
   virtual void vOnConnectionControlError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnConnectedDeviceStatusResult ( const tU8 /*u8Device*/, const tU8* const /*pu8Result*/ ) {}
   /**
    * \brief   */
   virtual void vOnConnectedDeviceStatusError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnDeviceLinkQualityResult ( const tU8 /*u8Device*/, tU8 /*u8LinkQuality*/ ) {}
   /**
    * \brief   */
   virtual void vOnDeviceLinkQualityError ( const tU32 /*errCode*/ ) {}
   /**
    * \brief   */
   virtual void vOnAuthenticatedDevicesPresentResult ( const tU8 /*u8Devices*/ ) {}
   /**
    * \brief   */
   virtual void vOnAuthenticatedDevicesPresentError ( const tU32 /*errCode*/ ) {}
   //! Signal to inform requester about success of the "BT link quality" request
//   virtual void vOnCustBTLinkQualityResult ( tU8 errorRate, tU8 linkQuality ) {}
   //! Signal to inform requester about failure of the "BT link quality" request
//   virtual void vOnCustBTLinkQualityError ( tDiaResult result ) {}
   //! forwards any errors on the Bluetooth interface
   virtual void vOnBT_SigQ_RSSIError ( const tU32 /*errCode*/ ) {}
   //! delivers the Bluetooth signal strength info
   virtual void vOnBT_SigQ_RSSI ( const  tU8 /*u8SigQ*/, tU8 /*u8RSSI*/ ) {}
protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IBluetoothNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IBluetoothNotifier
   : public dia_IBluetoothListener,
     public dia_Notifier<dia_IBluetoothListener>
{
public:
   //! notification of the current BT mode
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnBTModeStatus,dia_eBTMode)
   //! ACK to indicate if the request was accepted or rejected
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnBTModeRequestACK,tBool)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadMacAddressResult,const tU8* const)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadMacAddressError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadWifiMacAddressResult,const tU8* const)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadWifiMacAddressError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadCustBTMacAddressResult,const tU8* const)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadCustBTMacAddressError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadCustWifiMacAddressResult,const tU8* const)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadCustWifiMacAddressError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadBDAddressResult,const tU8* const)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadBDAddressError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnBDFieldstrengthResult,const tU8,const tU8)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnBDFieldstrengthError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnWifiFieldstrengthResult,const tU8,const tU8)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnWifiFieldstrengthError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectionControlResult,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnConnectionControlResult,const tU8,const tU8)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectionControlError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnConnectedDeviceStatusResult,const tU8,const tU8* const)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectedDeviceStatusError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnDeviceLinkQualityResult,const tU8,tU8)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnDeviceLinkQualityError,const tU32)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnAuthenticatedDevicesPresentResult,const tU8)
   /**
    * \brief   */
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnAuthenticatedDevicesPresentError,const tU32)
   //! Signal to inform requester about success of the "BT link quality" request
//   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnCustBTLinkQualityResult,tU8,tU8)
   //! Signal to inform requester about failure of the "BT link quality" request
//   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnCustBTLinkQualityError,tDiaResult)
   //! forwards any errors on the Bluetooth interface
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnBT_SigQ_RSSIError,const tU32)
   //! delivers the Bluetooth signal strength info
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnBT_SigQ_RSSI,const tU8,tU8)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__ */

