/*
 * dia_IAIVISecurity.h
 *
 *  Created on: 24.08.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY__
#define __INCLUDED_DIA_INTERFACE_AIVI_SECURITY__

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

class dia_IAIVISecurity
{
    DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_AIVI_SECURITY)

public:
    //! request the ECU Serial Number
    virtual tDiaResult getEcuSerialNumber ( void ) = 0;

    //! request the StaticKey used to encrypt the SecretSeed
    virtual tDiaResult getStaticKey ( void ) = 0;

    //! request the IndexSrvData used by the Unlocking Server to guess the StaticKey (when decrypting the SecuritySeed)
    virtual tDiaResult getIndexSrvData ( void ) = 0;

    //! request the StaticKey used to encrypt the SecretSeed for CMC
    virtual tDiaResult getStaticKey4CMCSecLevDoip ( void ) = 0;
protected:
    //! virtual base class destructor
    virtual ~dia_IAIVISecurity (void) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_AIVI_SECURITY__ */
