/************************************************************************
* FILE:           dia_CANSignalHandler.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    CSM-Signal-Interface for DIAGNOSIS.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 27.02.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_DIA_CANSIGNALHANDLER__
#define __INCLUDED_DIA_CANSIGNALHANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_CSM_IF__
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#define CSM_C_PROJECT_USERSPACE_EVOBUS
#include "csm_if.h"
#endif 

#ifndef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT 

class dia_CANSignalHandler

#else

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

class dia_CANSignalHandler : public dia_ITimerListener

#endif
{
public:
		
		/* Implement Singleton class with default constructor & destructor */
		DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR_WITH_SETUP_AND_TEARDOWN(dia_CANSignalHandler);
		//! class constructor
		dia_CANSignalHandler ( void );
		//! class destructor
		virtual ~dia_CANSignalHandler ( void );
		/* to get csm instance */
		static csm_tclCsmAccessUser* poGetCSMInstance();
		
		/* method to initialize csm proxy */
		//virtual void vInit();
		
		/* method to register csm signals */
		virtual void vRegisterCanSignals();
		
		/* method to unregister csm signals */
		virtual void vUnregisterCanSignals();
		
		/* method to unregister all csm signals at once */
		virtual void vUnregisterAllCanSignals();
		
		/* common method to write to csm signals */
		virtual void vSetSignalNewValue(tU32 /*u32SignalId*/, tVoid* /*pvNewSignalData*/, tU8 /*u8DataBufferLength*/, tU8 /*u8TxType*/);
public:
		/* common method to read csm signals*/
		virtual tDiaResult vReadSignalValue(tU32 /*u32SignalId*/, tU8* /*pvActSignalData*/, tU8 /*u8DataBufferLength*/);
		
		/* common signal indication callback method */
		static void vSignalIndCallback(tVoid* /*pHandle*/, tU32 /*signalId*/, tU32 /*state*/);

#ifndef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT 
#else
		//! overloaded method from class dia_ITimerListener
        virtual void vOnTimerElapsed ( dia_TimerID id );
#endif

        typedef struct dia_CANSignalOdometer
		{
			tU8 Odometer_Seg1 : 8;
			tU8 Odometer_Seg2 : 8;
			tU8 Odometer_Seg3 : 8;
			tU8 Odometer_Seg4 : 8;
		}sOdometer_Pkt;


		static std::vector<tU8> VinMessage;

    protected:

#ifndef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT 
#else
    	//! timer used when rolling out a system setting
   		dia_Timer mTimer;
#endif

   		// Variable to store Odometer data
		static sOdometer_Pkt m_rOdometer_Pkt;

	private:
	
		/* csm proxy interface declaration */
		static csm_tclCsmAccessUser* _poCSM;
		
};

struct dia_CANSignalRepo
{
	/* can signal name */
	tCString sSignalName;
	/* can signal id */
	tU32 u32SignalId;
};

typedef struct dia_CANSignalVIN
{
	tU8 VIN[8];
}sVIN_Pkt;

typedef struct dia_VinMsg
{
	std::vector<tU8> mVin;
}sVinMsg;

/* common methods to read to csm signals */
tDiaResult readOdometerValue(tU32* /* Odometer */);
tDiaResult getReceivedVIN(std::vector<tU8>& vecVin);
dia_CANSignalHandler* getInstanceOfCANSignalHandler ( void );
void releaseInstanceOfCANSignalHandler ( void );

/* *** *** *** Implement everything above this line *** *** *** */
#endif
