/*
 * dia_TraceCmdLogCANSignal.cpp
 *
 *  Created on: Sep 27, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef DIA_CANSIGNALLOGGING_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_CANSignalLogging.h"
#endif

#ifndef DIA_TRACECMDLOGCANSIGNAL_H_
#include "dia_TraceCmdLogCANSignal.h"
#endif

#define PARAM_START_STOP_INDEX  			(tU8) 5

#define START								(tU8) 0x01
#define STOP								(tU8) 0x00

#define MAX_NUMBER_OF_ALLOWED_CAN_SIGNALS   (tU8) 10

  // p = pMessage
   //              p0 p1 p2 p3  p4 p5  p6  p7  p8  p9
   //                       |   |  |   |   |   |   |
   // (2 bytes) cmdID     --|-+-|  |   |   |   |   |
   // (1 byte) START/STOP       ---|   |   |   |   |
   // (2 bytes) 1. CAN-Signal       ---|-+-|   |   |
   // (2 bytes) 2. CAN-Signal               ---|-+-|
   //  etc...

void dia_TraceCmdLogCANSignal::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdLogCANSignal::execute");

   DIA_TR_INF("dia_TraceCmdLogCANSignal::execute, message length = 0x%02x", pMessage[0]);

   for (tU8 i=0; i<pMessage[0]+1; i++) { // +1 because the very first byte is the size byte
	   DIA_TR_INF("dia_TraceCmdLogCANSignal::execute, pMessage[%d] = 0x%02x", i, pMessage[i]);
   }

   if (pMessage[0] < PARAM_START_STOP_INDEX) // At least 5 bytes has to come
   {
      DIA_TR_ERR("dia_TraceCmdLogCANSignal::execute Incorrect message length = 0x%02x", pMessage[0]);
      return;
   }

   if (pMessage[PARAM_START_STOP_INDEX] == START) { // Start CAN Signal registration

	   // Check if even number of bytes were delivered (for each CAN-Signal 2 bytes are needed)
	   if ((pMessage[0] - PARAM_START_STOP_INDEX) % 2 != 0) {
		   DIA_TR_ERR("dia_TraceCmdLogCANSignal::execute Incorrect number of bytes %d", pMessage[0] - PARAM_START_STOP_INDEX);
		   return;
	   }

	   tU8 totalNumberOfCANSignalsToRegister = (pMessage[0] - PARAM_START_STOP_INDEX)/2; // /2: Each CAN-Signal is identified with 2 Bytes
	   DIA_TR_INF("dia_TraceCmdLogCANSignal::execute, Starting registration for %d CAN-Signal", totalNumberOfCANSignalsToRegister);

	   if (totalNumberOfCANSignalsToRegister > MAX_NUMBER_OF_ALLOWED_CAN_SIGNALS) {
		   DIA_TR_ERR("dia_TraceCmdLogCANSignal::execute. Number of CAN-Signals exceeds max. number of CAN-Signals: %d", MAX_NUMBER_OF_ALLOWED_CAN_SIGNALS);
		   return;
	   }

	   std::vector<tU16> canSignalList;
	   for (tU8 canSignalFirstByte=1; canSignalFirstByte<totalNumberOfCANSignalsToRegister*2; canSignalFirstByte+=2) { // Iterate with the step value = 2
		   tU16 canSignal = U8_2_U16(pMessage[PARAM_START_STOP_INDEX+canSignalFirstByte], pMessage[PARAM_START_STOP_INDEX+canSignalFirstByte+1]); // Merge every 2 bytes to one value

		   DIA_TR_INF("dia_TraceCmdLogCANSignal::execute, Received for registration CAN-Signal: 0x%04X", canSignal);

		   canSignalList.push_back(canSignal);
	   }

	   if (canSignalList.size() != totalNumberOfCANSignalsToRegister) {
		   DIA_TR_ERR("dia_TraceCmdLogCANSignal::execute. Number of CAN-Signals doesn't match %d != %d", canSignalList.size(), totalNumberOfCANSignalsToRegister);
		   return;
	   }

	   // Register the new CAN-Signals
	   if (dia_CANSignalLogging::getInstance()->registerCANSignals(canSignalList) != DIA_SUCCESS) {
		   DIA_TR_ERR("dia_TraceCmdLogCANSignal::execute. Failed to register CAN-Signals!!!");
		   return;
	   }
   }
   else if (pMessage[PARAM_START_STOP_INDEX] == STOP) {  // Stop CAN Signal registration
	   DIA_TR_INF("dia_TraceCmdLogCANSignal::execute, Stopping registration for all CAN-Signal");

	   dia_CANSignalLogging::getInstance()->unregisterAllCANSignals();
   }
   else {
	   DIA_TR_ERR("dia_TraceCmdLogCANSignal::execute. Incorrect command type = 0x%02x", pMessage[PARAM_START_STOP_INDEX]);
	   return;
   }
}
