/*!
 * \file       dia_TraceCmdClearDTCs.h
 *
 * \brief      project specific Trace command for ClearDTC
 *
 * \details    project specific Trace command for ClearDTC
 *
 * \component  Diagnosis
 *
 * \ingroup    diaProjectTraceCommands
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_TRACECMDCLEARDTCS_H_
#define DIA_TRACECMDCLEARDTCS_H_

#ifndef __INCLUDED_DIA_TRACE_CMD__
#include "common/framework/trace/dia_TraceCmd.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOGASF_LISTENER__
#include "project/interfaces/dia_IErrorLogASFListener.h"
#endif


#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#include "common/interfaces/dia_ISensorListener.h"
#endif

class dia_TraceCmdClearDTCs 
	:	public dia_TraceCmd
{

public:

     //! class constructor
	 dia_TraceCmdClearDTCs ( tVoid );

     //! class destructor
     virtual ~dia_TraceCmdClearDTCs ( tVoid );

	 virtual void execute(const tU8* pMessage) const;

     //tU8 sendClearDTCRequest(tU8 Grp, tU32 Mask);

protected:
	struct Listener : public dia_IErrorLogASFListener
	{
	 virtual void vOnClearDTCResp(tU8 status);
	};

	const struct Listener m_Listener;


};

#endif /* DIA_TRACECMDCLEARDTCS_H_ */