/**
 * \file      dia_TestLoudspeaker.h
 *
 * \brief     {Test object to interact with dia_SAFeatureAudioTest->startLoudspeakerTest to start the loudspeaker DC test}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      Okt 05, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_TEST_LOUDSPEAKER_H_
#define __INCLUDED_DIA_TEST_LOUDSPEAKER_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOTEST_LISTENER__
#include "common/interfaces/dia_IAudioTestListener.h"
#endif

class dia_TestLoudspeaker
    : public dia_TestService,
      public dia_IAudioTestListener
{
//   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_TestLoudspeaker);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_TestLoudspeaker);

public:
   dia_TestLoudspeaker ( );

   virtual ~dia_TestLoudspeaker(void);

   //
   // overloaded methods from dia_TestService
   //

   //! @brief   Process the received service:
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   virtual void vOnTimeout ( void );

   //! Set property data vector
   virtual void setPropData(std::vector<tU32>& scrVect);

   //! Set property data vector
   virtual void setPropData(const tU32* setPropData, tU16 arraySize);

   //
   // overloaded methods from dia_IAudioTestListener
   //

   //! response to startLoudspeakerTest
   virtual void vOnLoudspeakerTest ( tDiaResult success );
   //! response to startTweeterTest
   virtual void vOnTweeterTest ( tDiaResult success );

protected:
   std::vector<tU32> mVectPropData;

};

#endif /*__INCLUDED_DIA_TEST_LOUDSPEAKER_H_*/
