/**
 * \file      dia_TestLoudspeaker.cpp
 *
 * \brief     Base class for unique ID generation of device configuration
 *
 * \details   Calculate checksum for configuration items and write it to registry mPropertyResultFingerprintLongFormat
 *
 * \author    kaa1hi
 * \date      Jul 21, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */
// DIA_REQ UDS 04 FD FD 0D


#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_TEST_LOUDSPEAKER_H_
#include "dia_TestLoudspeaker.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

//#ifndef __INCLUDED_EXT_DIAGLOG_IF__
//#include "project/framework/application/ext_diaglog_if.h"      //label for ITC
//#endif

//#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG__
//#include "common/interfaces/dia_IErrorLog.h"
//#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

//#define DIA_CONFIG_HASH_BINARY_SIZE    20)
#define DATA_START  1
#define DATA_LENGTH 0

//enum dia_ITC_value
//{
//   DIA_ITC_PASSED = 0,     /* =0 */
//   DIA_ITC_FAILED          /* =1 */
//};

using namespace std;

//-----------------------------------------------------------------------------

dia_TestLoudspeaker::dia_TestLoudspeaker ( )
   : dia_TestService("dia_TestLoudspeaker", DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_LOUDSPEAKER)
{
   dia_tclFnctTrace oTrace("dia_TestLoudspeaker::dia_TestLoudspeaker()");
}

//-----------------------------------------------------------------------------

dia_TestLoudspeaker::~dia_TestLoudspeaker ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_TestLoudspeaker::~dia_TestLoudspeaker !");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_TestLoudspeaker::setPropData(const tU32* pPropData, const tU16 sizeOfArray)
{
   dia_tclFnctTrace oTrace("dia_TestLoudspeaker::setPropData(Array)");
   DIA_TR_INF("dia_TestLoudspeaker::setPropData() sizeOfArray=%d", sizeOfArray);

   mVectPropData.clear();
   for (tU16 i=0; i<sizeOfArray; i++) {
      mVectPropData.push_back(pPropData[i]);
   }
}

//-----------------------------------------------------------------------------

void
dia_TestLoudspeaker::setPropData(std::vector<tU32>& scrVect)
{
   dia_tclFnctTrace oTrace("dia_TestLoudspeaker::setPropData(Vector)");
   mVectPropData.clear();

   for (std::vector<tU32>::iterator it = scrVect.begin(); it!=scrVect.end(); ++it){
      mVectPropData.push_back(*it);
   }
}

//-----------------------------------------------------------------------------

void
dia_TestLoudspeaker::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestLoudspeaker::vProcessRequest()");
   tBool errorDetected = TRUE;

   dia_IAudioTest* pAudioTest = 0;
   if (querySysAdapterInterface<dia_IAudioTest>(&pAudioTest) == DIA_SUCCESS)
   {
      if (pAudioTest) {
         (void) setSysAdapterListener<dia_IAudioTestListener>(this);
         if (pAudioTest->startLoudspeakerTest(DIA_EN_AUDIO_TEST_MODE_ON) == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
      DIA_TR_ERR("dia_TestLoudspeaker ---  SEND TO AUDIO TEST SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }

}

//----------------------------------------------------------------------------

void
dia_TestLoudspeaker::vOnLoudspeakerTest ( tDiaResult success ){
   dia_tclFnctTrace trc("dia_TestLoudspeaker::vOnLoudspeakerTest");

   if (success == DIA_SUCCESS) {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      // Sending back the positive answer
//      (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, U16_BYTE1(voltage));

      (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
      vResReadyAndQuit();
      DIA_TR_INF("dia_TestLoudspeaker::vOnLoudspeakerTest SUCCESSFUL");

   } else {
      // Sending back negative answer
      (void) unsetSysAdapterListener<dia_IAudioTestListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
      DIA_TR_ERR("dia_TestLoudspeaker::vOnLoudspeakerTest FAILED!");
   }

   // For Test Framework to end current test
   testTerminate();
}

//----------------------------------------------------------------------------

void
dia_TestLoudspeaker::vOnTweeterTest ( tDiaResult /*success*/ ){
   dia_tclFnctTrace oTrace("dia_TestLoudspeaker::vOnTweeterTest()");
}

//----------------------------------------------------------------------------

void
dia_TestLoudspeaker::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_TestLoudspeaker::vOnTimeout()");
   // For Test Framework to end current test
   testTerminate();
}
