/*
 * dia_TestInputEvent.cpp
 *
 *  Created on: 05.10.2015
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_TEST_INPUT_EVENT__
#include "project/framework/test/dia_TestInputEvent.h"
#endif

//-----------------------------------------------------------------------------

dia_TestInputEvent::dia_TestInputEvent ( void )
   : dia_TestService("dia_TestInputEvent", DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_INPUT_EVENT)
{
   dia_tclFnctTrace oTrace("dia_TestInputEvent::dia_TestInputEvent()");

}

//-----------------------------------------------------------------------------

dia_TestInputEvent::~dia_TestInputEvent ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_TestInputEvent::~dia_TestInputEvent !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_TestInputEvent::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestInputEvent::vProcessRequest()");

   dia_IInputHandling* pInterface = 0;
   tDiaResult retVal;
   if ((DIA_SUCCESS==(retVal=querySysAdapterInterface<dia_IInputHandling>(&pInterface))) && pInterface)
   {
      (void) setSysAdapterListener<dia_IInputHandlingListener>(this);

      if ( pInterface->enableInputEvents() != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_TestInputEvent::vProcessRequest UNABLE TO ENABLE INPUT EVENTS");
      }
      else
      {
         DIA_TR_INF("dia_TestInputEvent::vProcessRequest enableInputEvents successful");
      }
   }
   else
   {
      DIA_TR_ERR("dia_TestInputEvent::vProcessRequest - UNABLE TO ENABLE INPUT EVENTS!!!");
      DIA_TR_ERR("dia_TestInputEvent::vProcessRequest - ERROR pInterface=0x%p", pInterface);
      DIA_TR_ERR("dia_TestInputEvent::vProcessRequest - ERROR retVal=0x%08X", retVal);
   }

   testTerminate();
}

//-----------------------------------------------------------------------------

void
dia_TestInputEvent::vOnEnableInputEvents( const tBool bSimulationStatus )
{
   dia_tclFnctTrace oTrace("dia_TestInputEvent::vOnEnableInputEvents()");

   DIA_TR_INF("dia_TestInputEvent::vOnEnableInputEvents => bSimulationStatus = %d", bSimulationStatus);

   (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
}




