/*!
 * \file       dia_TestFactoryMode.h
 *
 * \brief      Internal Test for Factory Mode
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_TEST_FACTORY_MODE_H_
#include "dia_TestFactoryMode.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_EXT_DIAGLOG_IF__
#include "project/framework/application/ext_diaglog_if.h"      //label for ITC
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG__
#include "common/interfaces/dia_IErrorLog.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

const tU8 FACTORY_MODE_BIT = 0x01U;

enum dia_ITC_value
{
   DIA_ITC_PASSED = 0,     /* =0 */
   DIA_ITC_FAILED          /* =1 */
};

using namespace std;

dia_TestFactoryMode::dia_TestFactoryMode (tU16 itc)
   : dia_TestService("dia_TestFactoryMode", DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_FACTORY_MODE),
     mITC(itc)
{
   dia_tclFnctTrace oTrace("dia_TestFactoryMode::dia_TestFactoryMode()");
}

dia_TestFactoryMode::~dia_TestFactoryMode ( void )
{

}

void
dia_TestFactoryMode::setITC(bool IsFactoryModeActive)
{
   dia_tclFnctTrace oTrace("dia_TestFactoryMode::setITC()");

   tU8 message[4] = {0};

   DIA_TR_INF("dia_TestFactoryMode::setITC - result %s", ( IsFactoryModeActive? "DIA_ITC_FAILED": "DIA_ITC_PASSED"));

   // currently only 2 Bytes ITC supported
   message[0] = 3; // the first byte of the message is length of data container
   message[1] = (tU8)(mITC >> 8);
   message[2] = (tU8)(mITC & 0xFF);
   message[3] = IsFactoryModeActive ? DIA_ITC_FAILED : DIA_ITC_PASSED;

   dia_IErrorLog* pErrorLog = 0;
   tDiaResult retVal;
   if ((DIA_SUCCESS==(retVal=querySysAdapterInterface<dia_IErrorLog>(&pErrorLog))) && pErrorLog)
   {
      if ( pErrorLog->u32TestDTCStart(&message[0]) != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_TestFactoryMode::setITC UNABLE TO SET ITC label=0x%04X", mITC);
      }
      else
      {
         DIA_TR_INF("dia_TestFactoryMode::setITC itc=0x%04X u32TestDTCStart successful", mITC);
      }
   }
   else
   {
      DIA_TR_ERR("dia_TestFactoryMode::setITC - UNABLE TO SEND TEST RESULT!!!");
      DIA_TR_ERR("dia_TestFactoryMode::setITC - ERROR pErrorLog=0x%p", pErrorLog);
      DIA_TR_ERR("dia_TestFactoryMode::setITC - ERROR retVal=0x%08X", retVal);
   }
}


void
dia_TestFactoryMode::vProcessRequest( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestFactoryMode::vProcessRequest()");

   tU8 factoryMode = 0;
   tDiaResult retCode = dia_getProperty(DIA_PROP_AIVI_FACTORY_MODE, factoryMode);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("### dia_TestFactoryMode::vProcessRequest: errCode = 0x%08X FAILED TO RETRIEVE FACTORY MODE.", retCode);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }

   if (FACTORY_MODE_BIT & factoryMode)
   {
      DIA_TR_INF("dia_TestFactoryMode::vProcessRequest: Factory mode is enable.");
   }
   else
   {
      DIA_TR_INF("dia_TestFactoryMode::vProcessRequest: Factory mode is disable.");
   }

   //if factory mode is enable, dtc failed.
   enum dia_ITC_value itcVal = (FACTORY_MODE_BIT & factoryMode) ? DIA_ITC_FAILED: DIA_ITC_PASSED;
   setITC((bool)itcVal);

   testTerminate();
}

void
dia_TestFactoryMode::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_TestFactoryMode::vOnTimeout()");
   testTerminate();
}

//! positive response on clearing the fault memory
void dia_TestFactoryMode::vOnClearResult()
{
   dia_tclFnctTrace trc("dia_TestFactoryMode::vOnClearResult");
}

//! negative response on clearing the fault memory
void dia_TestFactoryMode::vOnClearError(tU32 u32Error)
{
   dia_tclFnctTrace trc("dia_TestFactoryMode::vOnClearError");

   unsetSysAdapterListener<dia_IErrorLogListener>(this);
   DIA_TR_ERR( "dia_TestFactoryMode::vProcessRequest => ERROR: %x",u32Error);
}
