/**
 * \file      dia_TestConfigHash_AIVI.h
 *
 * \brief     Test class for calculation of Configuration Hash in A-IVI project
 *
 * \details
 *
 *  ======================================================================================
 *   OEM TYPE | Expected CD | Calculated CD | Expected CD-DEF | DTC Nissan | DTC Renault |
 *  --------------------------------------------------------------------------------------
 *   NISSAN   | (don't care)| Hash1         | Hash1           | failed     | no update   |
 *  --------------------------------------------------------------------------------------
 *   NISSAN   | Hash1       | Hash1         | (don't care)    | passed     | no update   |
 *  --------------------------------------------------------------------------------------
 *   NISSAN   | Hash1       | Hash2         | (don't care)    | failed     | no update   |
 *  ======================================================================================
 *   RENAULT  | (don't care)| Hash1         | Hash1           | no update  | failed      |
 *  --------------------------------------------------------------------------------------
 *   RENAULT  | (don't care)| Hash1         | Hash2           | no update  | passed      |
 *  ======================================================================================
 *
 * \author    kaa1hi
 * \date      Nov 3, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_TEST_CONFIG_HASH_AIVI_H_
#define __INCLUDED_DIA_TEST_CONFIG_HASH_AIVI_H_

#ifndef __INCLUDED_DIA_TEST_CONFIG_HASH_H_
#include "common/framework/test/dia_TestConfigHash.h"
#endif

class dia_TestConfigHash_AIVI
    : public dia_TestConfigHash
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_TestConfigHash_AIVI);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_TestConfigHash_AIVI);

public:
   dia_TestConfigHash_AIVI(tU32 propRefConfFingerprintShortFormat, tU32 propResultFingerprintLongFormat, tU16 itc);

   virtual ~dia_TestConfigHash_AIVI(void);

protected:
   virtual bool checkAdditionalConditionForFPComparison(const std::vector<tU8> calculatedCDHash, bool result);

};

#endif /*__INCLUDED_DIA_TEST_CONFIG_HASH_H_*/
