/*
 * dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec.cpp
 *
 *  Created on: Apr 24, 2019
 *      Author: hgr6kor
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_DEFAULT_CONFIG_HISTORICAL_INTERROGATION_REC__
#include "project/framework/sysset/dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec.h"
#endif


//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec (Class constructor)
*
* DESCRIPTION: Specifies the Plugin ID.
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec ( void )
   : dia_SystemSettingsPlugin("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec")
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec()");

   addSupportedSysSetType(DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION);
}

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec (Class destructor)
*
* DESCRIPTION: -
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::~dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec ( void )
{
	DIA_TR_INF("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::~dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec()");
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    prepare
*
* DESCRIPTION: prepare for the upcoming system setting
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success
*
******************************************************************************/
#if 0
tDiaResult
dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::prepare (  dia_UID /*sysSetTypeUID*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::prepare()");
   return DIA_SUCCESS;
}
#endif
//------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    prepare
*
* DESCRIPTION:  perform the system set operation
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success - if file exists and deletion is successful
* 			   failure - if file deletion is not successful
*
******************************************************************************/
tDiaResult
dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::execute (  dia_UID sysSetTypeUID )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::execute()");
   DIA_TR_INF("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::execute() sysSetTypeUID = 0x%08x", sysSetTypeUID);

   tDiaResult retCode = DIA_FAILED;
   tU16 u16PropLength = dia_getPropertySize(DIA_PROP_CENTER_CMC_19_HISTORICAL_INTERROGATON_RECORD);
   tU8 u8PropData[u16PropLength] = {0};
   
   u8PropData[0]=DIA_DTC_COUNTER_DEFAULT_VAL;
   u8PropData[1]=DIA_ODOMETER_DEFAULT_VAL;
   u8PropData[2]=DIA_ODOMETER_DEFAULT_VAL; 
   
	// Try to save the Interrogation data into KDS
	if(DIA_SUCCESS == dia_setProperty ( DIA_PROP_CENTER_CMC_19_HISTORICAL_INTERROGATON_RECORD, u8PropData, u16PropLength ))
	{
        DIA_TR_INF("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::execute -> Done !!!");
		retCode = DIA_SUCCESS;
	}
	else
	{
		DIA_TR_ERR("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::execute -> Failed  !!!");
	}

	return retCode;

}
//------------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    finalize
*
* DESCRIPTION: finalize the system set operation
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success
*
******************************************************************************/
#if 0
tDiaResult
dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::finalize (  dia_UID /*sysSetTypeUID*/ )
{
	   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec::finalize()");
	   return DIA_SUCCESS;
}
#endif
//--------------------------------------------------------------------------------------
