/*
 * dia_SAFeatureVideoSource.h
 *
 *  Created on: 13.08.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATUREVIDEOSOURCE_H_
#define DIA_SAFEATUREVIDEOSOURCE_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "common/framework/sysadapters/dia_SystemAdapterFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOSOURCE_LISTENER__
#include "common/interfaces/dia_IVideoSourceListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h"
#endif

//#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
//#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
//#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class dia_SAFeatureVideoSource
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IVideoSource,
     public dia_IDiaglibRoutineControlListener
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureVideoSource);

public:
   //! constructor
   dia_SAFeatureVideoSource ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureVideoSource ( tVoid );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   //----------------------------------------------------------------------
   // Interface dia_IVideoSource
   //----------------------------------------------------------------------

   //! set the video source of the target
   virtual tDiaResult setVideoSource ( const dia_VideoSrcInfo& rVideoInfo );
   //! set the rvc control line mode
   virtual tDiaResult setRVCDisplay ( const dia_VideoSrcInfo& rVideoInfo );

   // receive functions
   virtual tVoid vOnRoutineCtrlResult(
         tU32 u32RoutineId,
         tenRoutineCtrlResult enRoutineStatus,
         const tDiaglibParamVector& oStartResult
   );

   virtual tVoid vOnGetRoutineResult(
         tU32 u32RoutineId,
         tenRoutineCtrlResult enRoutineStatus,
         const tDiaglibParamVector& oRoutineResult
   ) {
      DIA_PARAMETER_INTENTIONALLY_UNUSED(u32RoutineId);
      DIA_PARAMETER_INTENTIONALLY_UNUSED(enRoutineStatus);
      DIA_PARAMETER_INTENTIONALLY_UNUSED(oRoutineResult);
   }

protected:
   //--------------------------------------------------------------------------
   // Handlers for incoming messages
   //--------------------------------------------------------------------------
   virtual tBool bOnServiceStateAvailable(tU16 u16SrvID, tU16 u16SubId);

   //! handle incoming CCA message
   tVoid vHandleRoutineControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureVideoSource)
};


#endif /* DIA_SAFEATUREVIDEOSOURCE_H_ */
