/*
 * dia_SAFeatureVideoSource.cpp
 *
 *  Created on: 13.08.2012
 *      Author: shw2abt
 *  ---------------------------------------------------------------------------------------------------
 *  Date 			Author			Modification
 *  19.01.2016		bsu9kor			Added function setRVCDisplay(NCG3D 7515)
 */
#include "dia_SAFeatureVideoSource.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"

#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#include "common/diaglib/diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureVideoSource.cpp.trc.h"
#endif

//#ifndef __INCLUDED_DIA_MAIN__
//#include "common/depricated/dia_main.h"
//#endif
//
//#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
//#include "common/framework/sysadapters/dia_common_system_adapters.h"
//#endif

// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

BEGIN_MSG_MAP( dia_SAFeatureVideoSource, dia_SystemAdapterFeatureDiaglib )
//    ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, vHandleRoutineControl )
    ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, vHandleRoutineControl )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureVideoSource::dia_SAFeatureVideoSource (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureVideoSource::dia_SAFeatureVideoSource");
}

//------------------------------------------------------------------------------

dia_SAFeatureVideoSource::~dia_SAFeatureVideoSource ( tVoid )
{
//   dia_tclFnctTrace trc( ("dia_SAFeatureVideoSource::~dia_SAFeatureVideoSource") );
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVideoSource::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(ROUTINEID_VIDE_SOUR_SELE);
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVideoSource::setVideoSource ( const dia_VideoSrcInfo& rVideoInfo )
{
   dia_tclFnctTrace trc( ("dia_SAFeatureVideoSource::setVideoSource") );

   tDiaglibParamVector vecRequest;
   trParameter paramSource, paramNorm;

   paramSource.enType = static_cast<tenParameterType>(ROUTINEID_VIDE_SOUR_SELE_START_PARAM1);


   /* Match Diagnosis handling to RVC Handling */
   // DIA_EN_VIDEOSRC_INT => EN_VideoSourceINTERNAL = 0, // Set to Internal Video Source.
   // DIA_EN_VIDEOSRC_EXT => EN_VideoSourceEXTERNAL = 1, // Set to External Video Source.
   if(rVideoInfo.videoSrc==DIA_EN_VIDEOSRC_INT){
      paramSource.u8Value = 0x00;
      DIA_TR_INF( "dia_SAFeatureVideoSource::setVideoSource - Video Source: DIA_EN_VIDEOSRC_INT" );
   } else if (rVideoInfo.videoSrc==DIA_EN_VIDEOSRC_EXT){
      paramSource.u8Value = 0x01;
      DIA_TR_INF( "dia_SAFeatureVideoSource::setVideoSource - Video Source: DIA_EN_VIDEOSRC_EXT" );
   } else {
      DIA_TR_ERR( "dia_SAFeatureVideoSource::setVideoSource - Video Source(0x%02x) UNKNOWN!",paramSource.u8Value );
      return DIA_FAILED;
   }

   paramNorm.enType = static_cast<tenParameterType>(ROUTINEID_VIDE_SOUR_SELE_START_PARAM2);
   paramNorm.u8Value = rVideoInfo.videoNorm;

   DIA_TR_INF( "dia_SAFeatureVideoSource::setVideoSource - Video Source: 0x%02x",paramSource.u8Value );
   DIA_TR_INF( "dia_SAFeatureVideoSource::setVideoSource - Video Norm: 0x%02x", paramNorm.u8Value );

   vecRequest.push_back(paramSource);
   vecRequest.push_back(paramNorm);

   tBool retVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_VIDE_SOUR_SELE, 0, vecRequest, mpSrvPlugin /*this*/);

   return ( retVal == TRUE ) ? DIA_SUCCESS : DIA_FAILED;
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureVideoSource::vHandleRoutineControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc( ("dia_SAFeatureVideoSource::vHandleRoutineControl") );

   dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage( poMessage, this );
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureVideoSource::vOnRoutineCtrlResult (
                                                    tU32 u32RoutineId,
                                                    tenRoutineCtrlResult enRoutineStatus,
                                                    const tDiaglibParamVector& oStartResult
                                                 )
{
   dia_tclFnctTrace trc( ("dia_SAFeatureVideoSource::vOnRoutineCtrlResult") );

   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32RoutineId);

   dia_VideoSrcInfo videoInfo;
   videoInfo.videoSrc = DIA_EN_VIDEOSRC_UNKNOWN;
   videoInfo.videoNorm = DIA_EN_VIDEONORM_UNKNOWN;

   dia_IVideoSourceListener* pVideoListener = OSAL_NULL;
   querySysAdapterListener<dia_IVideoSourceListener>(&pVideoListener);

   if ( pVideoListener )
   {
      if ( EN_ROUTINE_CONTROL_OK == enRoutineStatus )
      {
         videoInfo.videoSrc = static_cast<dia_eVideoSource>(oStartResult[0].u8Value);
         videoInfo.videoNorm = static_cast<dia_eVideoNorm>(oStartResult[1].u8Value);

         DIA_TR_INF("dia_SAFeatureVideoSource::vOnRoutineCtrlResult - Video Source: 0x%02x", videoInfo.videoSrc);
         DIA_TR_INF("dia_SAFeatureVideoSource::vOnRoutineCtrlResult - Video Norm: 0x%02x", videoInfo.videoNorm);
         pVideoListener->vOnVideoSourceSelect(DIA_SUCCESS);
		 pVideoListener->vOnRVCDisplay(DIA_SUCCESS);
      }
      else     //if ( EN_ROUTINE_CONTROL_OK == enRoutineStatus )
      {
         DIA_TR_INF("dia_SAFeatureVideoSource::vOnRoutineCtrlResult - EN_ROUTINE_CONTROL_NOK !!");
         pVideoListener->vOnVideoSourceSelect(DIA_FAILED);
		 pVideoListener->vOnRVCDisplay(DIA_FAILED);
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureVideoSource::vOnRoutineCtrlResult - No listener registered");
   }
}

//------------------------------------------------------------------------------

tBool
dia_SAFeatureVideoSource::bOnServiceStateAvailable ( tU16 /* u16SrvID */, tU16 /* u16SubId */ )
{
   dia_tclFnctTrace trc( ("dia_SAFeatureVideoSource::bOnServiceStateAvailable") );
   return TRUE;
}
/******************************************************************************
* FUNCTION:    setRVCDisplay
*
* DESCRIPTION: Routine control to activate RVC Control Line status ON/OFF.
*
* PARAMETER:   dia_eRVCControl_ControlLine mode- Status of RVC control Line (ON/OFF).
*
* RETURNVALUE: SUCCESS  - RVC control line set success.
*              FALSE - RVC control line set failed.
*
******************************************************************************/
tDiaResult
dia_SAFeatureVideoSource::setRVCDisplay (  const dia_VideoSrcInfo& rVideoInfo )
{
	   dia_tclFnctTrace trc( ("dia_SAFeatureVideoSource::setRVCDisplay") );

	   tDiaglibParamVector vecRequest;
	   trParameter paramSource, paramNorm;

	   paramSource.enType = static_cast<tenParameterType>(ROUTINEID_VIDE_SOUR_SELE_START_PARAM1);


	   /* Match Diagnosis handling to RVC Handling */
	   // DIA_EN_VIDEOSRC_INT => EN_VideoSourceINTERNAL = 0, // Set to Internal Video Source.
	   // DIA_EN_VIDEOSRC_EXT => EN_VideoSourceEXTERNAL = 1, // Set to External Video Source.
	   if(rVideoInfo.videoSrc==DIA_EN_VIDEOSRC_INT){
	      paramSource.u8Value = 0x00;
	      DIA_TR_INF( "dia_SAFeatureVideoSource::setRVCDisplay - Video Source: DIA_EN_VIDEOSRC_INT" );
	   } else if (rVideoInfo.videoSrc==DIA_EN_VIDEOSRC_EXT){
	      paramSource.u8Value = 0x01;
	      DIA_TR_INF( "dia_SAFeatureVideoSource::setRVCDisplay - Video Source: DIA_EN_VIDEOSRC_EXT" );
	   } else {
	      DIA_TR_ERR( "dia_SAFeatureVideoSource::setRVCDisplay - Video Source(0x%02x) UNKNOWN!",paramSource.u8Value );
	      return DIA_FAILED;
	   }

	   paramNorm.enType = static_cast<tenParameterType>(ROUTINEID_VIDE_SOUR_SELE_START_PARAM2);
	   paramNorm.u8Value = rVideoInfo.videoNorm;

	   DIA_TR_INF( "dia_SAFeatureVideoSource::setRVCDisplay - Video Source: 0x%02x",paramSource.u8Value );
	   DIA_TR_INF( "dia_SAFeatureVideoSource::setRVCDisplay - Video Norm: 0x%02x", paramNorm.u8Value );

	   vecRequest.push_back(paramSource);
	   vecRequest.push_back(paramNorm);

	   tBool retVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_VIDE_SOUR_SELE, 0, vecRequest, mpSrvPlugin /*this*/);

	   return ( retVal == TRUE ) ? DIA_SUCCESS : DIA_FAILED;
}
