/*
 * dia_SystemAdapterVehicleData.h
 *
 *  Created on: 11.01.2011
 *      Author: gib2hi
 *      -----------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      14.12.2015  bsu9kor		Added function setHMILanguage and corresponding handler function vHandleSetHMILanguage
 *		14.12.2015  bsu9kor		Added function getHMILanguage and corresponding handler function vHandleGetHMILanguage
 *		22.12.2015	bsu9kor		Added Interface and enum changes
 *      ------------------------------------------------------------------------------------------------------------------------
 */

#ifndef DIA_SAFEATUREVEHICLEDATA_H_
#define DIA_SAFEATUREVEHICLEDATA_H_

// implemented interfaces
#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_VCAN__
#include "project/interfaces/dia_INissanVCanInfoListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_PARKINGBRAKE_LISTENER__
#include "common/interfaces/dia_IParkingBrakeListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REVERSEGEAR_LISTENER__
#include "common/interfaces/dia_IReverseGearListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE__
#include "project/interfaces/dia_INissanLanguage.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SENSORSPEED_LISTENER__
#include "common/interfaces/dia_ISensorSpeedListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VEHICLECLIENT_LISTENER__
#include "project/interfaces/dia_IVehicleClientListener.h"
#endif

#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_TYPES
#include "vehicle_fi_if.h"


class amt_tclServiceData;

class dia_SAFeatureVehicleData
    : public dia_SystemAdapterFeature,
      public dia_INissanVCanInfo,
      public dia_IParkingBrake,
      public dia_IReverseGear,
      public dia_INissanLanguage,
	   public dia_ISensorSpeed,
      public dia_IVehicleClient
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureVehicleData);

public:
   //! default class constructor
   dia_SAFeatureVehicleData ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
   //! class destructor
   virtual ~dia_SAFeatureVehicleData ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_SystemAdapterFeature methods
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult startMonitoring ( void );
   
   //
   // implementation of the dia_INissanVCanInfo interface
   //
   virtual tDiaResult getNissanVCANInfo ( void );
   //! request the current state of the CSM signal HandBrake.
   virtual tDiaResult getVCanCsmHandBrakeInfo ( void );
   //
   // implementation of the dia_IParkingBrake interface
   //
   //! request current hand brake state
   virtual tDiaResult getParkingBrakeStatus ( void );
   //
   // implementation of the dia_IReverseGear interface
   //
   //! receives component response about reverse gear status
   virtual tDiaResult getReverseGearStatus (  );
   //
   // implementation of the dia_ISensorSpeed interface
   //
   //! receives component response about speed
    virtual tDiaResult getSensorSpeed (  );

   //! set new hmi language
    tDiaResult setHMILanguage ( dia_eNissanLanguage u8Country );
   //! read current hmi language
    tDiaResult getHMILanguage ( tVoid  );

   //! read Total vehicle distance value
   virtual tDiaResult getTotalVehDistDiag ( void  );

protected:
   //! handle the result of a defset message
   void vHandleNissanNetworkState ( amt_tclServiceData* poMessage ) const;
   //! handle the result of a defset message
   void vHandleNissanVCanCsmHandBrake ( amt_tclServiceData* poMessage ) const;
   //! receives current hand brake signal
   void vHandleHandBrakeState ( amt_tclServiceData* poMessage ) const;
   //! receives current reverse gear state
   void vHandleReverseGearState(amt_tclServiceData* poMessage) const;
   //handlers for HMI language
   //! Handle get hmi language
   void vHandleGetHMILanguage(amt_tclServiceData* poMessage) const;
   //! Handle set hmi language
   void vHandleSetHMILanguage(amt_tclServiceData* poMessage) const;
   //! Handle get speed informtion
   void vHandleSensorSpeed(amt_tclServiceData* poMessage) const;
   //! reply on getting total distance info from CAN
   void vHandleTotalVehDistDiag (amt_tclServiceData* poMessage) const;

   void vHandleRegionStatusDiag (amt_tclServiceData* poMessage) const;

   tBool bSendMessage (
         const tU8  u8MessageType,
         const tU16 u16FID,
         const tU8  u8Opcode,
         const tU16 u16MsgLength,
         const tU8  u8MsgBuffer[]
   );

   std::map<vehicle_fi_tcl_e8_Language_Code::tenType, dia_eNissanLanguage> mLanguages;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureVehicleData)
};

#endif /* DIA_SAFEATUREVEHICLEDATA_H_ */
