/*
 * dia_SystemAdapterVehicleData.cpp
 *
 *  Created on: 13.08.2012
 *      Author:
 *
 *
 *      -----------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      14.12.2015  bsu9kor		Added function setHMILanguage and corresponding handler function vHandleSetHMILanguage
 *		14.12.2015  bsu9kor		Added function getHMILanguage and corresponding handler function vHandleGetHMILanguage
 *      22.12.2015  bsu9kor		Added Interface and enum changes to above functions
 *      ------------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

// lint -e1516
// lint -e1712
// lint -e1735
// lint -e1739
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_STDVISITORS
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_FUNCTIONIDS
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_TYPES
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_ERRORCODES
#include "vehicle_fi_if.h"
// lint +e1516
// lint +e1712
// lint +e1735
// lint +e1739

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_VCAN__
#include "project/interfaces/dia_INissanVCanInfoListener.h"
#endif

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_BUS_STATE__
#include "project/interfaces/dia_INissanBusStateListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE_LISTENER__
#include "project/interfaces/dia_INissanLanguageListener.h"
#endif

#include "dia_SAFeatureVehicleData.h"

#include "common/framework/config/dia_ConfigManager.h"

#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#include "diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __DIA_UNIT_TESTING__
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureVehicleData.cpp.trc.h"
#endif
#endif

#define DIA_C_LIST_SIZE_ECU_ABSENT_STATES             ((tU8) 19)

#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_AVM         ((tU8) 0)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_BCM         ((tU8) (ITC_AIVI_VCAN_ABSENT_BCM - ITC_AIVI_VCAN_START))
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_CLUSTER     ((tU8) (ITC_AIVI_VCAN_ABSENT_CLUSTER - ITC_AIVI_VCAN_START))
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_ECM         ((tU8) (ITC_AIVI_VCAN_ABSENT_ECM - ITC_AIVI_VCAN_START))
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_STRG        ((tU8) 4)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_VDC         ((tU8) 5)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_USM         ((tU8) (ITC_AIVI_VCAN_ABSENT_USM - ITC_AIVI_VCAN_START))
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_ADASCOP     ((tU8) 7)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_HVAC        ((tU8) 8)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_ATCVT       ((tU8) 9)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_TIREP       ((tU8) 10)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_TPMS        ((tU8) 11)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_RCU         ((tU8) 12)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_SBCM        ((tU8) 13)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_RAS         ((tU8) 14)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_SONAR       ((tU8) 15)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_HCM         ((tU8) 16)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_DSC         ((tU8) 17)
#define DIA_C_LIST_INDEX_ECU_ABSENT_STATE_IDM         ((tU8) 18)

#define DIA_C_LIST_SIZE_MCAN_CHANNEL_MUTE_STATES      ((tU8) 9)

#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_SWC  ((tU8) (ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR - ITC_AIVI_MCAN_START))
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_AUD  ((tU8) (ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR - ITC_AIVI_MCAN_START))
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_NAV  ((tU8) 2)
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_TCU  ((tU8) 3)
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_BOSE ((tU8) 4)
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_RSE  ((tU8) 5)
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_ISP  ((tU8) 6)
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_RCS  ((tU8) 7)
#define DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_AMP  ((tU8) 8)

enum dia_eNissanECUVCAN
{
   DIA_EN_NISSAN_ECU_VCAN_BUS = ITC_AIVI_VCAN_BUS_OFF - ITC_AIVI_VCAN_START,
   DIA_EN_NISSAN_ECU_VCAN_MUTE = ITC_AIVI_VCAN_MUTE_ERROR - ITC_AIVI_VCAN_START,
   DIA_EN_NISSAN_ECU_VCAN_COUNT = 256
};

enum dia_eNissanEcuMCAN
{
   DIA_EN_NISSAN_ECU_MCAN_COUNT = 256
};

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureVehicleData, dia_SystemAdapterFeature)
   ON_MESSAGE(VEHICLE_MAINFI_C_U16_NETWORKSTATE, vHandleNissanNetworkState)
   ON_MESSAGE(VEHICLE_MAINFI_C_U16_HANDBRAKE, vHandleHandBrakeState)
   ON_MESSAGE(VEHICLE_MAINFI_C_U16_REVERSEGEAR, vHandleReverseGearState)
   ON_MESSAGE(VEHICLE_MAINFI_C_U16_LANGUAGE, vHandleGetHMILanguage)
   ON_MESSAGE(VEHICLE_MAINFI_C_U16_SETLANGUAGE, vHandleSetHMILanguage)
   ON_MESSAGE(VEHICLE_MAINFI_C_U16_SPEED, vHandleSensorSpeed)
  ON_MESSAGE(VEHICLE_MAINFI_C_U16_TOTALVEHDISTDIAG, vHandleTotalVehDistDiag)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureVehicleData::dia_SAFeatureVehicleData(
    tCString name, // feature name
    dia_SystemAdapterServicePlugin &pSrvPlugin)
    : dia_SystemAdapterFeature(name, pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::dia_SAFeatureVehicleData");

   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US] = DIA_EN_NISSAN_LANGUAGE_ENGLISH_US;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_CHINESE_CANTONESE_SIMPLIFIED_CHINESE_CHARACTER] = DIA_EN_NISSAN_LANGUAGE_CHINESE;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_UK] = DIA_EN_NISSAN_LANGUAGE_ENGLISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_GERMAN] = DIA_EN_NISSAN_LANGUAGE_GERMAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_PORTUGUESE] = DIA_EN_NISSAN_LANGUAGE_PORTUGESE;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ALBANESE] = DIA_EN_NISSAN_LANGUAGE_ALBANESE;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ARABIC] = DIA_EN_NISSAN_LANGUAGE_ARABIC;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_BULGARIAN] = DIA_EN_NISSAN_LANGUAGE_BULGARIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER] = DIA_EN_NISSAN_LANGUAGE_CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER] = DIA_EN_NISSAN_LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_CROATIAN] = DIA_EN_NISSAN_LANGUAGE_CROATIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_CZECH] = DIA_EN_NISSAN_LANGUAGE_CZECH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_DANISH] = DIA_EN_NISSAN_LANGUAGE_DANISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_DUTCH] = DIA_EN_NISSAN_LANGUAGE_DUTCH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_AUSTRALIAN] = DIA_EN_NISSAN_LANGUAGE_ENGLISH_AUSTRALIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US_FOR_JPN] = DIA_EN_NISSAN_LANGUAGE_ENGLISH_US_FOR_JPN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US_FOR_PRC] = DIA_EN_NISSAN_LANGUAGE_ENGLISH_US_FOR_PRC;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_CANADIAN] = DIA_EN_NISSAN_LANGUAGE_ENGLISH_CANADIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_INDIA] = DIA_EN_NISSAN_LANGUAGE_ENGLISH_INDIA;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ESTONIAN] = DIA_EN_NISSAN_LANGUAGE_ESTONIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_FINNISH] = DIA_EN_NISSAN_LANGUAGE_FINNISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_FLEMISH] = DIA_EN_NISSAN_LANGUAGE_FLEMISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_FRENCH] = DIA_EN_NISSAN_LANGUAGE_FRENCH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_FRENCH_CANADIAN] = DIA_EN_NISSAN_LANGUAGE_FRENCH_CANADIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_GREEK] = DIA_EN_NISSAN_LANGUAGE_GREEK;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_HEBREW] = DIA_EN_NISSAN_LANGUAGE_HEBREW;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_HINDI] = DIA_EN_NISSAN_LANGUAGE_HINDI;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_HUNGARIAN] = DIA_EN_NISSAN_LANGUAGE_HUNGARIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_INDONESIAN] = DIA_EN_NISSAN_LANGUAGE_INDONESIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ITALIAN] = DIA_EN_NISSAN_LANGUAGE_ITALIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_JAPANESE] = DIA_EN_NISSAN_LANGUAGE_JAPANESE;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_KOREAN] = DIA_EN_NISSAN_LANGUAGE_KOREAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_LATVIAN] = DIA_EN_NISSAN_LANGUAGE_LATVIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_LITHUANIAN] = DIA_EN_NISSAN_LANGUAGE_LITHUANIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_MALAY] = DIA_EN_NISSAN_LANGUAGE_MALAY;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_NORWEGIAN] = DIA_EN_NISSAN_LANGUAGE_NORWEGIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_PERSIAN_FARSI_IRANIAN] = DIA_EN_NISSAN_LANGUAGE_PERSIAN_FARSI_IRANIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_PHILIPPINES] = DIA_EN_NISSAN_LANGUAGE_PHILIPPINES;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_POLISH] = DIA_EN_NISSAN_LANGUAGE_POLISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_PORTUGUESE_BRAZILIAN] = DIA_EN_NISSAN_LANGUAGE_PORTUGUESE_BRAZILIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_ROMANIAN] = DIA_EN_NISSAN_LANGUAGE_ROMANIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_RUSSIAN] = DIA_EN_NISSAN_LANGUAGE_RUSSIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SERBIAN] = DIA_EN_NISSAN_LANGUAGE_SERBIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SLOVAKIAN] = DIA_EN_NISSAN_LANGUAGE_SLOVAKIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SLOVENIAN] = DIA_EN_NISSAN_LANGUAGE_SLOVENIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH] = DIA_EN_NISSAN_LANGUAGE_SPANISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH_LATIN_AMERICAN] = DIA_EN_NISSAN_LANGUAGE_SPANISH_LATIN_AMERICAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH_MEXICAN] = DIA_EN_NISSAN_LANGUAGE_SPANISH_MEXICAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_SWEDISH] = DIA_EN_NISSAN_LANGUAGE_SWEDISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_TAIWANESE] = DIA_EN_NISSAN_LANGUAGE_TAIWANESE;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_THAI] = DIA_EN_NISSAN_LANGUAGE_THAI;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_TURKISH] = DIA_EN_NISSAN_LANGUAGE_TURKISH;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_UKRAINIAN] = DIA_EN_NISSAN_LANGUAGE_UKRAINIAN;
   mLanguages[vehicle_fi_tcl_e8_Language_Code::FI_EN_VIETNAMESE] = DIA_EN_NISSAN_LANGUAGE_VIETNAMESE;
}

//-----------------------------------------------------------------------------

dia_SAFeatureVehicleData::~dia_SAFeatureVehicleData(void)
{
}

//-----------------------------------------------------------------------------/*

tDiaResult dia_SAFeatureVehicleData::startMonitoring(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::startMonitoring()");

   tDiaResult retCode = DIA_SUCCESS;

   if (_bFidReg == FALSE)
   {
      if (registerFunction(VEHICLE_MAINFI_C_U16_HANDBRAKE) != DIA_SUCCESS)
      {
         retCode = DIA_FAILED;
      }
      if (registerFunction(VEHICLE_MAINFI_C_U16_REVERSEGEAR) != DIA_SUCCESS)
      {
         retCode = DIA_FAILED;
      }

      if (retCode != DIA_SUCCESS)
      {
         DIA_TR_ERR("##### AT LEAST ONE REGISTRATION TO VEHICLE_DATA PROPERTIES FAILED #####");
      }
      else
      {
         _bFidReg = TRUE;
      }
   }

   return retCode;
}

tDiaResult
dia_SAFeatureVehicleData::getNissanVCANInfo(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getNissanVCANInfo()");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getNissanVCANInfo() - send message.");
      gm_tclEmptyMessage oMessage(
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
#ifdef VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_FUNCTIONIDS
          VEHICLE_MAINFI_C_U16_NETWORKSTATE,
#else
          CFC_VEHICLEFI_C_U16_NETWORKSTATE,
#endif
          CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureVehicleData::getNissanVCANInfo()- transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::getNissanVCANInfo() - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getNissanVCANInfo() - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureVehicleData::getNissanVCANInfo() - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo()");

   tDiaResult retCode = DIA_FAILED;

#if 0 // TODO
    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo() - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          CFC_VEHICLEFI_C_U16_CSMHANDBRAKE,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo()- transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo() - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo() - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureVehicleData::getVCanCsmHandBrakeInfo() - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
#endif

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVehicleData::getParkingBrakeStatus(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getParkingBrakeStatus()");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getParkingBrakeStatus() - send message.");
      gm_tclEmptyMessage oMessage(
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          VEHICLE_MAINFI_C_U16_HANDBRAKE,
          CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureVehicleData::getParkingBrakeStatus()- transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::getParkingBrakeStatus() - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getParkingBrakeStatus() - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureVehicleData::getParkingBrakeStatus() - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVehicleData::getReverseGearStatus()
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getReverseGearStatus()");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getReverseGearStatus() - send message.");
      gm_tclEmptyMessage oMessage(
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          VEHICLE_MAINFI_C_U16_REVERSEGEAR,
          CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureVehicleData::getReverseGearStatus()- transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::getReverseGearStatus() - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getReverseGearStatus() - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureVehicleData::getReverseGearStatus() - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

tDiaResult
dia_SAFeatureVehicleData::getSensorSpeed(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getSensorSpeed");
   tDiaResult retCode = DIA_FAILED;
   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getSensorSpeed - send message.");
      gm_tclEmptyMessage oMessage(
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          VEHICLE_MAINFI_C_U16_SPEED,
          CCA_C_U8_OPCODE_GET);
      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureVehicleData::getSensorSpeed - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::getSensorSpeed - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getSensorSpeed - getRegistrationID failed.");
   }
   return retCode;
}
//-----------------------------------------------------------------------------
//=============================================================================
//=============================================================================

void dia_SAFeatureVehicleData::vHandleNissanNetworkState(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleNissanNetworkState");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
   {
      fi_tclVisitorMessage oStatusMessage(poMessage);
      vehicle_mainfi_tclMsgNetworkStateStatus oStatusMsgData;
      (void)oStatusMessage.s32GetData(oStatusMsgData);

      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - u8BusState_VCAN = 0x%x .", oStatusMsgData.u8BusState_VCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - u8BusState_MCAN = 0x%x .", oStatusMsgData.u8BusState_MCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - u8MuteState_VCAN = 0x%x .", oStatusMsgData.u8MuteState_VCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - u8MuteState_MCAN = 0x%x .", oStatusMsgData.u8MuteState_MCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - bBusOff_VCAN = %d .", oStatusMsgData.bBusOff_VCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - bBusOff_MCAN = %d .", oStatusMsgData.bBusOff_MCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - bMute_VCAN = %d .", oStatusMsgData.bMute_VCAN);
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - bMute_MCAN = %d .", oStatusMsgData.bMute_MCAN);

#ifndef __DIA_UNIT_TESTING__
      ETG_TRACE_COMP(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Listu8AbsentStateVCAN_ECU: %02x",
                      ETG_LIST_LEN(oStatusMsgData.Listu8AbsentState_ECU.size()),
                      ETG_LIST_PTR_T8(const_cast<tU8 *>(&oStatusMsgData.Listu8AbsentState_ECU[0]))));
      ETG_TRACE_COMP(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Listu8MuteStateMCAN_Channel: %02x",
                      ETG_LIST_LEN(oStatusMsgData.Listu8MuteStateMCAN_Channel.size()),
                      ETG_LIST_PTR_T8(const_cast<tU8 *>(&oStatusMsgData.Listu8MuteStateMCAN_Channel[0]))));
#else
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Listu8AbsentState_ECU size = %d .",
                 oStatusMsgData.Listu8AbsentState_ECU.size());

      for (tU32 i = 0; i < oStatusMsgData.Listu8AbsentState_ECU.size(); i++)
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Listu8AbsentState_ECU[%d] = 0x%x .",
                    i, oStatusMsgData.Listu8AbsentState_ECU[i]);
      }

      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Listu8MuteStateMCAN_Channel size = %d .",
                 oStatusMsgData.Listu8MuteStateMCAN_Channel.size());

      for (tU32 j = 0; j < oStatusMsgData.Listu8MuteStateMCAN_Channel.size(); j++)
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Listu8MuteStateMCAN_Channel[%d] = 0x%x .",
                    j, oStatusMsgData.Listu8MuteStateMCAN_Channel[j]);
      }
#endif

      dia_INissanVCanInfoListener *pVCanListener = OSAL_NULL;

      if ((querySysAdapterListener<dia_INissanVCanInfoListener>(&pVCanListener) == DIA_SUCCESS) && pVCanListener)
      {
#if 1
         dia_NissanVCanInfo nwInfo(DIA_EN_NISSAN_ECU_VCAN_COUNT);

         for (tU32 i = 0; i < oStatusMsgData.Listu8AbsentState_ECU.size(); i++)
         {
            nwInfo.setDiagByte((tU8)i, oStatusMsgData.Listu8AbsentState_ECU[i]);
         }

         nwInfo.setDiagByte(DIA_EN_NISSAN_ECU_VCAN_BUS, oStatusMsgData.u8BusState_VCAN);
         nwInfo.setDiagByte(DIA_EN_NISSAN_ECU_VCAN_MUTE, oStatusMsgData.u8MuteState_VCAN);

         pVCanListener->vOnVCanInfo(nwInfo);
#else
         // component provides generic format of connected devices. Each entry (tU8) consists of a
         std::list<tU8> deviceInfoList;
         deviceInfoList.push_back(oStatusMsgData.u8BusState_VCAN);
         deviceInfoList.push_back(oStatusMsgData.u8MuteState_VCAN);
         for (tU8 i = 0; i < oStatusMsgData.Listu8AbsentState_ECU.size(); i++)
         {
            deviceInfoList.push_back(oStatusMsgData.Listu8AbsentState_ECU[i]);
         }
         pVCanListener->vOnVCanInfo(deviceInfoList);
#endif

         DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - VCAN Information forwarded to listener"));
      } // if ( pVCanListener )
      else
      {
         DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - No VCAN listener registered. Discarded!"));
      }

      dia_INissanBusStateListener *pBusListener = OSAL_NULL;
      querySysAdapterListener<dia_INissanBusStateListener>(&pBusListener);
      if (pBusListener)
      {
         dia_NissanBusState nwState(DIA_EN_NISSAN_ECU_MCAN_COUNT);

         // new FI support
         nwState.setDiagByte(DIA_EN_NISSAN_BUS_VCAN, oStatusMsgData.u8BusState_VCAN);
         nwState.setDiagByte(DIA_EN_NISSAN_BUS_MCAN, oStatusMsgData.u8BusState_MCAN);
         nwState.setDiagByte(DIA_EN_NISSAN_MUTE_MCAN, oStatusMsgData.u8MuteState_MCAN);
         // new MCAN ECU mute support
#if 1
         for (tU32 i = 0; i < oStatusMsgData.Listu8MuteStateMCAN_Channel.size(); i++)
         {
            nwState.setMCanMuteState((tU8)i, oStatusMsgData.Listu8MuteStateMCAN_Channel[i]);
         }
#else
         if (oStatusMsgData.Listu8MuteStateMCAN_Channel.size() >= DIA_C_LIST_SIZE_MCAN_CHANNEL_MUTE_STATES)
         {
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_SWC, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_SWC]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_AUD, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_AUD]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_NAV, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_NAV]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_TCU, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_TCU]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_BOSE, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_BOSE]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_RSE, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_RSE]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_ISP, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_ISP]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_RCS, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_RCS]);
            nwState.setMCanMuteState(DIA_EN_NISSAN_ECU_MCAN_MUTE_AMP, oStatusMsgData.Listu8MuteStateMCAN_Channel[DIA_C_LIST_INDEX_MCAN_CHANNEL_MUTE_STATE_AMP]);
         }
#endif
         pBusListener->vOnBusStateInfo(nwState);

         DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - bus state forwarded to listener"));
      }
      else
      {
         DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - No bus state listener registered. Discarded!"));
      }
   }
   break;

   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
   {
      DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanNetworkState - Message with opcode error received"));
   }
   break;

   default:
      break;
   }

   // Delete the message we are unable process it at this time
   (void)poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void dia_SAFeatureVehicleData::vHandleHandBrakeState(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleHandBrakeState");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
   {
      dia_IParkingBrakeListener *pListener = OSAL_NULL;
      querySysAdapterListener<dia_IParkingBrakeListener>(&pListener);
      if (pListener)
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
         vehicle_mainfi_tclMsgHandBrakeStatus oStatusMsgData;
         (void)oStatusMessage.s32GetData(oStatusMsgData);

         dia_eParkingBrakeState brakeState = DIA_EN_PARKING_BRAKE_UNKNOWN;
         switch (oStatusMsgData.e8Status.enType)
         {
         case vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_OFF:
            DIA_TR_INF("dia_SAFeatureVehicleData::vHandleHandBrakeState - Hand Brake is OFF.");
            brakeState = DIA_EN_PARKING_BRAKE_OFF;
            break;
         case vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_ON:
            DIA_TR_INF("dia_SAFeatureVehicleData::vHandleHandBrakeState - Hand Brake is ON.");
            brakeState = DIA_EN_PARKING_BRAKE_ON;
            break;
         default:
            DIA_TR_ERR("dia_SAFeatureVehicleData::vHandleHandBrakeState - Hand Brake signal 0x%02x not covered!", oStatusMsgData.e8Status.enType);
            DIA_TR_ERR("dia_SAFeatureVehicleData::vHandleHandBrakeState - Hand Brake connected?");
            break;
         }

         pListener->vOnParkingBrakeStatus(brakeState);
      } // if ( pListener )
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleHandBrakeState - No listener registered. Discarded!");
      }
   }
   break;

   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleHandBrakeState - Message with opcode error received");
   }
   break;

   default:
      break;
   }

   // Delete the message we are unable process it at this time
   (void)poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void dia_SAFeatureVehicleData::vHandleReverseGearState(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleReverseGearState");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
   {
      dia_IReverseGearListener *pListener = OSAL_NULL;
      querySysAdapterListener<dia_IReverseGearListener>(&pListener);
      if (pListener)
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
         vehicle_mainfi_tclMsgReverseGearStatus oStatusMsgData;
         (void)oStatusMessage.s32GetData(oStatusMsgData);

         dia_eReverseGearStatus reverseGearState = DIA_EN_REVERSE_GEAR_UNKNOWN;
         switch (oStatusMsgData.State)
         {
         case 0: // OFF
            DIA_TR_INF("dia_SAFeatureVehicleData::vHandleReverseGearState - Reverse Gear Off.");
            reverseGearState = DIA_EN_REVERSE_GEAR_OFF;
            break;
         case 1: // ON
            DIA_TR_INF("dia_SAFeatureVehicleData::vHandleReverseGearState - Reverse Gear On.");
            reverseGearState = DIA_EN_REVERSE_GEAR_ON;
            break;
         default: // Unknown case
            DIA_TR_ERR("dia_SAFeatureVehicleData::vHandleReverseGearState - UNKNOWN GEAR STATE!");
            DIA_TR_ERR("dia_SAFeatureVehicleData::vHandleReverseGearState - Reverse Gear connected?");
            break;
         }

         pListener->vOnReverseGearStatus(reverseGearState);
      } // if ( pListener )
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleReverseGearState - No listener registered. Discarded!");
      }
   }
   break;

   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleReverseGearState - Message with opcode error received");
   }
   break;

   default:
      break;
   }

   // Delete the message we are unable process it at this time
   (void)poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void dia_SAFeatureVehicleData::vHandleNissanVCanCsmHandBrake(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleNissanVCanCsmHandBrake");

#if 0 // TODO
   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
         cfc_vehiclefi_tclMsgCsmHandBrakeStatus oStatusMsgData;
         (void) oStatusMessage.s32GetData(oStatusMsgData);
         DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanVCanCsmHandBrake - Received Network State"));
         dia_INissanVCanInfoListener* pVCanListener = OSAL_NULL;
         querySysAdapterListener<dia_INissanVCanInfoListener>(&pVCanListener);
         if ( pVCanListener )
         {
            pVCanListener->vOnVCanCsmHandBrakeInfo(oStatusMsgData.CsmHandBrakeData, oStatusMsgData.CsmHandBrakeState);
            DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanVCanCsmHandBrake - VCAN Information forwarded to listener"));
         }
         else
         {
             DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanVCanCsmHandBrake - No VCAN listener registered. Discarded!"));
         }
      }
      break;
   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      {
           DIA_TR_INF(("dia_SAFeatureVehicleData::vHandleNissanVCanCsmHandBrake - Message with opcode error received"));
      }
      break;
   default:
      break;
   }
#endif
   // Delete the message we are unable process it at this time
   (void)poMessage->bDelete();
}

//------------------------------------------------------------------------------------
/******************************************************************************
 * FUNCTION:    setHMILanguage
 *
 * DESCRIPTION: send CCA MethodStart message to trigger HMI Language Set
 *
 * PARAMETER:   u8Country - Language to be Set on HMI
 *
 * RETURNVALUE: TRUE  - transmitMessage to component success
 *              FALSE - transmitMessage to component failed
 *
 ******************************************************************************/

tDiaResult
dia_SAFeatureVehicleData::setHMILanguage(dia_eNissanLanguage u8Country)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::setHMILanguage()");
   tDiaResult retCode = DIA_FAILED;
   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::setHMILanguage - send message.");

      if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
      {

         vehicle_mainfi_tclMsgSetLanguageMethodStart oMsgData;
         vehicle_fi_tcl_e8_Language_Code::tenType fi_Language;
         fi_Language = vehicle_fi_tcl_e8_Language_Code::FI_EN_UNKNOWN;
         oMsgData.SourceId.enType = vehicle_fi_tcl_e8_Language_SourceId::FI_EN_DIAG;

         std::map<vehicle_fi_tcl_e8_Language_Code::tenType, dia_eNissanLanguage>::const_iterator iter;
         for (iter = mLanguages.begin(); iter != mLanguages.end(); iter++)
         {
            if (iter->second == u8Country)
            {
               fi_Language = iter->first;
               DIA_TR_INF("dia_SAFeatureVehicleData::setHMILanguage - DIA = %d / FI: 0x%02x.", u8Country, fi_Language);
               break;
            }
         }

         if (fi_Language == vehicle_fi_tcl_e8_Language_Code::FI_EN_UNKNOWN)
         {
            DIA_TR_ERR("dia_SAFeatureVehicleData::setHMILanguage - UNKNOWN Language %d", u8Country);
            DIA_ASSERT_ALWAYS();
         }

         oMsgData.Language.enType = fi_Language;
         fi_tclVisitorMessage oMessage(oMsgData);
         mpSrvPlugin->vInitServiceData(oMessage, VEHICLE_MAINFI_C_U16_SETLANGUAGE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureVehicleData::setHMILanguage - transmitMessage success.");
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureVehicleData::setHMILanguage - transmitMessage failed.");
         }
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::setHMILanguage - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureVehicleData::setHMILanguage - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }
   return retCode;
}

//--------------------------------------------------------------------------------------------------
/******************************************************************************
 * FUNCTION:    getHMILanguage
 *
 * DESCRIPTION: send CCA PropertyGet message to Read active HMI Language
 *
 * PARAMETER:   void
 *
 * RETURNVALUE: TRUE  - transmitMessage to component success
 *              FALSE - transmitMessage to component failed
 *
 ******************************************************************************/
tDiaResult
dia_SAFeatureVehicleData::getHMILanguage(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getHMILanguage()");
   tDiaResult retCode = DIA_FAILED;
   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getHMILanguage() - send message.");
      gm_tclEmptyMessage oMessage(
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          VEHICLE_MAINFI_C_U16_LANGUAGE,
          AMT_C_U8_CCAMSG_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureVehicleData::getHMILanguage()- transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::getHMILanguage() - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getHMILanguage() - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureVehicleData::getHMILanguage() - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}
//----------------------------------------------------------------------------------------------------------------------
/****************************************************************************************************************
 * FUNCTION:    vHandleSetHMILanguage
 *
 * DESCRIPTION: handles CCA MethodResult message
 *
 * PARAMETER:   poMessage - Pointer to class amt_tclServiceData responsible for contacting the component
 *
 * RETURNVALUE: void
 *
 *
 *****************************************************************************************************************/
void dia_SAFeatureVehicleData::vHandleSetHMILanguage(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleSetHMILanguage()");

   // the opcode tells what we should do
   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleSetHMILanguage - Received language");
      dia_INissanLanguageListener *pListener = 0;
      if (((querySysAdapterListener<dia_INissanLanguageListener>(&pListener)) == DIA_SUCCESS) && pListener)
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
         vehicle_mainfi_tclMsgSetLanguageMethodResult oStatusMsgData;
         (void)oStatusMessage.s32GetData(oStatusMsgData);
         DIA_TR_INF("Language set status %d", oStatusMsgData.Result);

         if (true == oStatusMsgData.Result)
         {
            pListener->vOnSetHMILanguage(DIA_SUCCESS);
            DIA_TR_INF("Language is set successfully");
         }
         else
         {
            pListener->vOnSetHMILanguage(DIA_FAILED);
            DIA_TR_INF("Language is not supported");
         }
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleSetHMILanguage - language forwarded to listener");
      }
      else
      {
         DIA_TR_INF("-- querySysAdapterListener<dia_INissanLanguageListener> failed");
      }
   }
   break;
   default:
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleSetHMILanguage - OpCode not ok");
   }
   break;
   }
}
//-------------------------------------------------------------------------------------------------------------------------------------
/****************************************************************************************************************
 * FUNCTION:    vHandleGetHMILanguage
 *
 * DESCRIPTION: handles CCA PropertyStatus message
 *
 * PARAMETER:   poMessage - Pointer to class amt_tclServiceData responsible for contacting the component
 *
 * RETURNVALUE: void
 *
 *
 *****************************************************************************************************************/
void dia_SAFeatureVehicleData::vHandleGetHMILanguage(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace oTrace("dia_SAFeatureVehicleData::vHandleGetHMILanguage()");
   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleGetHMILanguage - Received language");
      dia_eNissanLanguage language = DIA_EN_NISSAN_LANGUAGE_UNKNOWN;
      dia_INissanLanguageListener *pListener = 0;
      if ((querySysAdapterListener<dia_INissanLanguageListener>(&pListener) == DIA_SUCCESS) && pListener)
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
         vehicle_mainfi_tclMsgLanguageStatus oStatusMsgData;
         (void)oStatusMessage.s32GetData(oStatusMsgData);

         std::map<vehicle_fi_tcl_e8_Language_Code::tenType, dia_eNissanLanguage>::const_iterator iter = mLanguages.find(oStatusMsgData.Language.enType);
         if (iter != mLanguages.end())
         {
            language = iter->second;
            DIA_TR_INF("dia_SAFeatureVehicleData::vHandleGetHMILanguage - FI: 0x%02x / DIA = %d.",
                       oStatusMsgData.Language.enType, language);
         }
         else
         {
            DIA_TR_ERR("dia_SAFeatureVehicleData::vHandleGetHMILanguage - Unknown: 0x%02x.", oStatusMsgData.Language.enType);
            DIA_ASSERT_ALWAYS();
         }

         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleGetHMILanguage - Current language forwarded to listener");
         pListener->vOnGetHMILanguage(language);
      }
   }
   break;
   default:
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleGetHMILanguage - OpCode not ok");
   }
   break;
   }
}
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------
/****************************************************************************************************************
 * FUNCTION:    vHandleSensorSpeed
 *
 * DESCRIPTION: handles CCA PropertyStatus message
 *
 * PARAMETER:   poMessage - Pointer to class amt_tclServiceData responsible for contacting the component
 *
 * RETURNVALUE: void
 *
 *
 *****************************************************************************************************************/

void dia_SAFeatureVehicleData::vHandleSensorSpeed(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleSensorSpeed");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_STATUS)
   {
      fi_tclVisitorMessage oStatusMessage(poMessage);
      vehicle_mainfi_tclMsgSpeedStatus oStatusMsgData;
      (void)oStatusMessage.s32GetData(oStatusMsgData);

      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleSensorSpeed - Receive speed message.");

      dia_ISensorSpeedListener *pListener = OSAL_NULL;
      querySysAdapterListener<dia_ISensorSpeedListener>(&pListener);
      if (pListener)
      {
         tU16 u16Speed = oStatusMsgData.SpeedValue;
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleSensorSpeed - speed=%d", u16Speed);
         if (u16Speed == SENSOR_SPEED_INVALID)
         {
            u16Speed = SENSOR_SPEED_INVALID;
         }
         pListener->vOnSensorSpeed(u16Speed);
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleSensorSpeed - Message with unhandled/unknown opcode received:");
   }

   // Delete the message we are unable process it at this time
   (void)poMessage->bDelete();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVehicleData::getTotalVehDistDiag(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::getTotalVehDistDiag");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getTotalVehDistDiag() - send message.");
      gm_tclEmptyMessage oMessage(
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          VEHICLE_MAINFI_C_U16_TOTALVEHDISTDIAG,
          CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureVehicleData::getTotalVehDistDiag()- transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureVehicleData::getTotalVehDistDiag() - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureVehicleData::getTotalVehDistDiag() - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureVehicleData::getTotalVehDistDiag() - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void dia_SAFeatureVehicleData::vHandleTotalVehDistDiag(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleTotalVehDistDiag");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_STATUS)
   {
      fi_tclVisitorMessage oStatusMessage(poMessage);
      vehicle_mainfi_tclMsgTotalVehDistDiagStatus oStatusMsgData;
      (void)oStatusMessage.s32GetData(oStatusMsgData);

      DIA_TR_INF("dia_SAFeatureVehicleData::vHandleTotalVehDistDiag - Receive speed message.");

      dia_IVehicleClientListener *pListener = OSAL_NULL;
      querySysAdapterListener<dia_IVehicleClientListener>(&pListener);
      if (pListener)
      {
         tU32 u32Dist = oStatusMsgData.TotalVehDistDiagValue;
         DIA_TR_INF("dia_SAFeatureVehicleData::vHandleTotalVehDistDiag - distance=%d", u32Dist);
         pListener->vOnTotalVehDistDiag(u32Dist);
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleTotalVehDistDiag - Message with unhandled/unknown opcode received:");
   }

   // Delete the message we are unable process it at this time
   (void)poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void dia_SAFeatureVehicleData::vHandleRegionStatusDiag(amt_tclServiceData *poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureVehicleData::vHandleRegionStatusDiag");
   ETG_TRACE_USR3_THR(("-->dia_SAFeatureVehicleData::vHandleRegionStatusDiag"));

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag - Message received:");
   DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag: Received OpCode %d", u8OpCode);

   constexpr tU16 REGION_STATUS_BYTE_INDEX = 227;

   // Get property size and allocate vector
   tU16 Proplength = dia_getPropertySize(DIA_PROP_CM_DAB_TUNER_PARAMETER_SET);
   std::vector<tU8> PropDataVec(Proplength);

   // Read the current property values
   tDiaResult retCode = dia_getProperty(DIA_PROP_CM_DAB_TUNER_PARAMETER_SET, PropDataVec);
   if (retCode != DIA_SUCCESS)
   {
      ETG_TRACE_ERRMEM(("!!! vHandleRegionStatusDiag => unable to read from KDS memory"));
      NORMAL_M_ASSERT_ALWAYS();
      return;
   }

   // Safety check for vector size
   if (REGION_STATUS_BYTE_INDEX >= PropDataVec.size())
   {
      ETG_TRACE_ERRMEM(("!!! vHandleRegionStatusDiag => Invalid byte index %d for property size %d", REGION_STATUS_BYTE_INDEX, static_cast<int>(PropDataVec.size())));
      NORMAL_M_ASSERT_ALWAYS();
      return;
   }

   tU8 currentValue = PropDataVec[REGION_STATUS_BYTE_INDEX];
   tU8 currentLowerNibble = currentValue & 0x0F;
   tU8 newLowerNibble = currentLowerNibble; // default, no change

   if (u8OpCode == 4)
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag - OpCode == 4");

      if (currentLowerNibble != 0x0A)
      {
         newLowerNibble = 0x0A;
      }
   }
   else if (u8OpCode == 0)
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag - OpCode == 0");

      if (currentLowerNibble != 0x02)
      {
         newLowerNibble = 0x02;
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag - OpCode %d: No modification", u8OpCode);
      // No change required for other opcodes
      return;
   }

   if (newLowerNibble != currentLowerNibble)
   {
      // Preserve upper 4 bits, update lower 4 bits only
      PropDataVec[REGION_STATUS_BYTE_INDEX] = (currentValue & 0xF0) | newLowerNibble;

      // Write back the updated property vector
      if (dia_setProperty(DIA_PROP_CM_DAB_TUNER_PARAMETER_SET, PropDataVec) != DIA_SUCCESS)
      {
         ETG_TRACE_ERRMEM(("!!! dia_SAFeatureVehicleData::vHandleRegionStatusDiag => unable to write into the KDS memory"));
         NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag - Updated byte 227 to 0x%02X", PropDataVec[REGION_STATUS_BYTE_INDEX]);
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleRegionStatusDiag - No update needed at byte 227");
   }
}