/*
 * dia_SAFeatureVDMMGR.h
 *
 *  Created on: 26.09.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATUREVDMMGR_H_
#define DIA_SAFEATUREVDMMGR_H_

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VD_MMGR_LISTENER__
#include "common/interfaces/dia_IVDMMGRListener.h"
#endif


#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_SERVICEINFO
#include "mplay_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureVDMMGR
   : public dia_SystemAdapterFeature,
     public dia_IVDMMGR
{
public:
   //! constructor
   dia_SAFeatureVDMMGR ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureVDMMGR ( tVoid );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IVDMMGR methods
   //
   //-------------------------------------------------------------------------

   /**
    * \brief      start/stop CD/DVD intensive/short test - LCN2KAI shortform
    *
    * \param[in]  dia_eDriveTestType selftestType - tests if it is a short, intensive or TEF test
    *
    * \return     DIA_SUCCESS:  sending MethodStart message successfully
    *             DIA_FAILED:   sending MethodStart message failed
    */
   virtual tDiaResult startCDDriveTest( dia_eDriveTestType selftestType );

   /**
    * \brief      start/stop CD/DVD intensive/short test - all parameters
    *
    * \param[in]  const tU8 duration
    * \param[in]  const tU16 drive
    * \param[in]  const tU16 driveTestCmd
    * \param[in]  const tU16 driveTestParam
    *
    * \return     DIA_SUCCESS:  sending MethodStart message successfully
    *             DIA_FAILED:   sending MethodStart message failed
    */
   virtual tDiaResult startCDDriveTest( const tU8 duration, const tU16 drive, const tU16 driveTestCmd, dia_eDriveTestType driveTestParam );

   /**
    * \brief      get the CD drive media type
    *
    * \param[in]  none
    *
    * \return     DIA_SUCCESS:  sending Get message successfully
    *             DIA_FAILED:   sending Get message failed
    */
   virtual tDiaResult getOpticalDriveMediaType( void );

   /**
    * \brief      get the CD drive loader status
    *
    * \param[in]  none
    *
    * \return     DIA_SUCCESS:  sending Get message successfully
    *             DIA_FAILED:   sending Get message failed
    */
   virtual tDiaResult getOpticalDriveLoaderStatus( void );

   /**
    * \brief      eject CD/DVD
    *
    * \param[in]  none
    *
    * \return     DIA_SUCCESS:  sending MethodStart message successfully
    *             DIA_FAILED:   sending MethodStart message failed
    */
   virtual tDiaResult ejectCD( tVoid );

   /**
    * \brief      select CD Mode (CDDA / CD ROM)
    *
    * \param[in]  dia_eDVM_CDModeSwitch2 switch2CDMode
    *
    * \return     DIA_SUCCESS:  sending MethodStart message successfully
    *             DIA_FAILED:   sending MethodStart message failed
    */
   virtual tDiaResult selectCDMode( dia_eMMgr_CDModeSwitch2 switch2CDMode );

protected:
   //! deprecated default constructor
   dia_SAFeatureVDMMGR ( tVoid );

   //! handle CCA message returning information about the CD drive test
   virtual tVoid vHandleCDDriveTest     ( amt_tclServiceData* poMessage ) const;

   //! handle CCA message returning media type information from CD drive
   virtual tVoid vHandleCDDriveMediaType( amt_tclServiceData* poMessage ) const;

   //! handle CCA message returning CD drive loader status
   virtual tVoid vHandleCDDriveLoaderStatus( amt_tclServiceData* poMessage ) const;

   //! handle CCA message running eject controlled by diagnosis
   virtual tVoid vHandleControlEject( amt_tclServiceData* poMessage ) const;

   //! handle CCA message running select CD mode by diagnosis
   void vHandleSelectTrackType( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureVDMMGR)

private:
   const std::map<dia_eDriveTestType, mplay_fi_tcl_e16_DiagDrvTestParam::tenType > mMapTestTypeToFITestType =
   {
      {DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT,       mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT},
      {DIA_EN_MMGR_DRIVE_TEST_TYPE_INTENSIVE,   mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_INTENSIVE},
      {DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT_TEF,   mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT_TEF_CD}
   };
};

#endif /* DIA_SAFEATUREVDMMGR_H_ */
