/*
 * dia_SAFeatureVDMMGR.cpp
 *
 *  Created on: 26.09.2012
 *      Author: shw2abt, fgl2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VD_MMGR__
#include "common/interfaces/dia_IVDMMGR.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "mplay_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "dia_SAFeatureVDMMGR.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureVDMMGR,dia_SystemAdapterFeature)
   ON_MESSAGE( MPLAY_MMGRFI_C_U16_DIAGCONTROLDRIVETEST,  vHandleCDDriveTest )
#if 0
   ON_MESSAGE( MIDW_MMGRFI_C_U16_CDINFO,                vHandleCDDriveMediaType )
#endif
   ON_MESSAGE( MPLAY_MMGRFI_C_U16_DIAGLOADSTATUS,        vHandleCDDriveLoaderStatus )
   ON_MESSAGE( MPLAY_MMGRFI_C_U16_DIAGCONTROLEJECT,      vHandleControlEject )
   ON_MESSAGE( MPLAY_MMGRFI_C_U16_DIAGCDSELECTTRACKTYPE, vHandleSelectTrackType )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureVDMMGR::dia_SAFeatureVDMMGR(
      tCString name,// feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
)
: dia_SystemAdapterFeature( name, pSrvPlugin )
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::dia_SAFeatureVDMMGR" );
}

//-----------------------------------------------------------------------------

dia_SAFeatureVDMMGR::~dia_SAFeatureVDMMGR(tVoid)
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVDMMGR::startCDDriveTest(dia_eDriveTestType selftestType)
{
   dia_tclFnctTrace trc("dia_SAFeatureVDMMGR::startCDDriveTest(dia_eDriveTestType)");

   std::map<dia_eDriveTestType, mplay_fi_tcl_e16_DiagDrvTestParam::tenType >::const_iterator it = mMapTestTypeToFITestType.find(selftestType);
   if ( it == mMapTestTypeToFITestType.end() )
   {
      DIA_TR_ERR("dia_SAFeatureVDMMGR::startCDDriveTest FAILED. Wrong test type 0x%02X.", selftestType);
      return DIA_FAILED;
   }

   return startCDDriveTest( mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_SINGLE_RUN, mplay_fi_tcl_e16_DiagDrv::FI_EN_MMGR_CD,
                            mplay_fi_tcl_e16_DiagDrvTestCmd::FI_EN_MMGR_START, selftestType );
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVDMMGR::startCDDriveTest( const tU8 /*duration*/, const tU16 /*drive*/, const tU16 /*driveTestCmd*/, dia_eDriveTestType driveTestType )
{
   dia_tclFnctTrace trc("dia_SAFeatureVDMMGR::startCDDriveTest(const tU8, const tU16, const tU16, dia_eDriveTestType)");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      //fill data with the setting
      mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart oData;



      oData.e8Duration.enType = mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_SINGLE_RUN; //+contiuous
      oData.StartDriveTestParam.e16Drive.enType = mplay_fi_tcl_e16_DiagDrv::FI_EN_MMGR_CD; // fest           // FI_EN_MMGR_CD = 1UL
      oData.StartDriveTestParam.e16DriveTestCmd.enType = mplay_fi_tcl_e16_DiagDrvTestCmd::FI_EN_MMGR_START;  // FI_EN_MMGR_START = 1UL

      std::map<dia_eDriveTestType, mplay_fi_tcl_e16_DiagDrvTestParam::tenType >::const_iterator it = mMapTestTypeToFITestType.find(driveTestType);
      if ( it != mMapTestTypeToFITestType.end() )
      {
         mplay_fi_tcl_e16_DiagDrvTestParam::tenType testType = it->second;
         if      (testType==mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT)         DIA_TR_INF("dia_SAFeatureVDMMGR::startCDDriveTest FI_EN_MMGR_SHORT");
         else if (testType==mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_INTENSIVE)     DIA_TR_INF("dia_SAFeatureVDMMGR::startCDDriveTest FI_EN_MMGR_INTENSIVE");
         else if (testType==mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT_TEF_CD)  DIA_TR_INF("dia_SAFeatureVDMMGR::startCDDriveTest FI_EN_MMGR_SHORT_TEF_CD");

          oData.StartDriveTestParam.e16DriveTestParam.enType = testType;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureVDMMGR::startCDDriveTest FAILED. Wrong test type 0x%02X.", driveTestType);
         return DIA_FAILED;
      }

      DIA_TR_INF( "duration %d, drive %d, driveTestCmd %d, driveTestParam %d.", oData.e8Duration.enType, oData.StartDriveTestParam.e16Drive.enType,
                  oData.StartDriveTestParam.e16DriveTestCmd.enType, oData.StartDriveTestParam.e16DriveTestParam.enType );

      fi_tclVisitorMessage oMsg( oData );
      mpSrvPlugin->vInitServiceData( oMsg, MPLAY_MMGRFI_C_U16_DIAGCONTROLDRIVETEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART );
      if( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF( "dia_SAFeatureVDMMGR::startCDDriveTest - bTransmitMessage success." );
      }
      else
      {
         DIA_TR_ERR( "dia_SAFeatureVDMMGR::startCDDriveTest - bTransmitMessage failed." );
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureVDMMGR::startCDDriveTest - getRegistrationID failed.");
   }

   return retCode;
}

//-----------------------------------------------------------------------
tDiaResult dia_SAFeatureVDMMGR::getOpticalDriveMediaType( void )
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::getOpticalDriveMediaType()" );

   tDiaResult retCode = DIA_FAILED;

#if 0
   if( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      // init generic message for VD MMgr property CDINFO
      gm_tclEmptyMessage oMessage(  mAppID,
                                    mpSrvPlugin->getClientID(),
                                    mpSrvPlugin->getRegistrationID(),
                                    0,
                                    mpSrvPlugin->getServiceID(),
                                    MIDW_MMGRFI_C_U16_CDINFO,
                                    AMT_C_U8_CCAMSG_OPCODE_GET
                                 );

      if( mpSrvPlugin->bTransmitMessage( &oMessage ) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF( "dia_SAFeatureVDMMGR::getOpticalDriveMediaType() - SUCCESS." );
      }
      else
      {
         DIA_TR_INF( "dia_SAFeatureVDMMGR::getOpticalDriveMediaType() - FAILED." );
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureVDMMGR::getOpticalDriveMediaType - getRegistrationID failed.");
   }
#endif

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureVDMMGR::getOpticalDriveLoaderStatus( void )
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::getOpticalDriveLoaderStatus()" );

   tDiaResult retCode = DIA_FAILED;

   if( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      //fill data with CD drive
      mplay_mmgrfi_tclMsgDiagLoadStatusGet oData;
      oData.Drive.enType = mplay_fi_tcl_e16_DiagDrv::FI_EN_MMGR_CD;
      fi_tclVisitorMessage oMsg( oData );
      mpSrvPlugin->vInitServiceData( oMsg, MPLAY_MMGRFI_C_U16_DIAGLOADSTATUS, AMT_C_U8_CCAMSG_OPCODE_GET );

      if( mpSrvPlugin->bTransmitMessage( &oMsg ) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF( "dia_SAFeatureVDMMGR::getOpticalDriveLoaderStatus() - SUCCESS." );
      }
      else
      {
         DIA_TR_ERR( "dia_SAFeatureVDMMGR::getOpticalDriveLoaderStatus() - FAILED." );
      }
   }
   else
   {
      DIA_TR_ERR( "dia_SAFeatureVDMMGR::getOpticalDriveLoaderStatus - getRegistrationID failed." );
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureVDMMGR::ejectCD( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureVDMMGR::ejectCD");
   tDiaResult retCode = DIA_FAILED;

   if( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      //fill data with the setting
      mplay_mmgrfi_tclMsgDiagControlEjectMethodStart oData;

      oData.e8Duration.enType = mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_SINGLE_RUN;
      oData.StartEjectParam.e16Drive.enType = mplay_fi_tcl_e16_DiagDrv::FI_EN_MMGR_CD;

      DIA_TR_INF( "dia_SAFeatureVDMMGR::ejectCD - Data to send:" );
      fi_tclVisitorMessage oMsg( oData );
      mpSrvPlugin->vInitServiceData( oMsg, MPLAY_MMGRFI_C_U16_DIAGCONTROLEJECT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART );
      if( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF( "dia_SAFeatureVDMMGR::ejectCD - bTransmitMessage success." );
      }
      else
      {
         DIA_TR_ERR( "dia_SAFeatureVDMMGR::ejectCD - bTransmitMessage failed." );
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureVDMMGR::ejectCD - getRegistrationID failed.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureVDMMGR::selectCDMode( dia_eMMgr_CDModeSwitch2 switch2CDMode )
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::selectCDMode()" );

   tDiaResult retCode = DIA_FAILED;

   if( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF( "dia_SAFeatureVDMMGR::selectCDMode - CD Mode to switch = %d", switch2CDMode );
      //fill data with the setting
      mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart oData;
      oData.TrackType.enType =  ( switch2CDMode == DIA_EN_MMGR_CD_MODE_SWITCH_TO_CDROM ) ? mplay_fi_tcl_e8_TrackType::FI_EN_DATA : mplay_fi_tcl_e8_TrackType::FI_EN_AUDIO;
      DIA_TR_INF( "dia_SAFeatureVDMMGR::selectCDMode - send message with selected track type = %d", oData.TrackType.enType );
      fi_tclVisitorMessage oMsg( oData );
      mpSrvPlugin->vInitServiceData( oMsg, MPLAY_MMGRFI_C_U16_DIAGCDSELECTTRACKTYPE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART );

      if( mpSrvPlugin->bTransmitMessage( &oMsg ) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF( "dia_SAFeatureVDMMGR::selectCDMode - transmitMessage success." );
      }
      else
      {
         DIA_TR_INF( "dia_SAFeatureVDMMGR::selectCDMode - transmitMessage failed." );
      }
   }
   else
   {
      DIA_TR_INF( "dia_SAFeatureVDMMGR::selectCDMode - getRegistrationID failed." );
      DIA_TR_INF( "dia_SAFeatureVDMMGR::selectCDMode - getRegistrationID == AMT_C_U16_REGID_INVALID." );
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureVDMMGR::vHandleCDDriveTest( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::vHandleCDDriveTest()" );

   if( poMessage )
   {
      DIA_ASSERT( poMessage->bIsServerMessage() == TRUE );

      dia_IVDMMGRListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IVDMMGRListener>(&pListener);
      if( pListener )
      {
         if( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULTFIRST )
         {
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveTest AMT_C_U8_CCAMSG_OPCODE_METHODRESULTFIRST" );
            pListener->vOnCDDriveSelftestStarted( DIA_SUCCESS );
         }
         else if( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
         {
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveTest AMT_C_U8_CCAMSG_OPCODE_METHODRESULT" );

            fi_tclVisitorMessage oReceivedMsg( poMessage );
            mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult oReceivedData;
            (tVoid)oReceivedMsg.s32GetData( oReceivedData );

            // midw_fi_tcl_e8_DiagDuration e8Duration;
            tU8 duration = oReceivedData.e8Duration.enType;

            if( oReceivedData.ResultDriveTest.e8RetValueDriveTest.enType != mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_OK )
            {
               pListener->vOnCDDriveSelftestStarted( DIA_FAILED );

               DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveTest vOnCDDriveSelftest START FAILED/UNABLE." );
            }
            else
            {
               mplay_fi_tcl_DiagMethodResultDrvTest methodResultDriveTest = oReceivedData.ResultDriveTest;

               dia_tDriveTestResult testResult;

               testResult.mType = DIA_EN_MMGR_DRIVE_TYPE_CD;

               switch ( methodResultDriveTest.e16DiagDrvTesttype.enType )
               {
               case mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT:
                  testResult.mTestType = DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT;
                  break;
               case mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_INTENSIVE:
                  testResult.mTestType = DIA_EN_MMGR_DRIVE_TEST_TYPE_INTENSIVE;
                  break;
               case mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT_TEF_CD:
                  testResult.mTestType = DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT_TEF;
                  break;
               default:
                  testResult.mTestType = DIA_EN_MMGR_DRIVE_TEST_TYPE_UNKNOWN;
                  break;
               }

               switch ( methodResultDriveTest.e8RetValueDriveTest.enType )
               {
               case mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_FALSE:
                  testResult.mReturnValue = DIA_E_ROUTINE_FAILED;
                  break;
               case mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_OK:
                  testResult.mReturnValue = DIA_E_ROUTINE_COMPLETE;
                  break;
               case mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_NO_MEDIA:
                  testResult.mReturnValue = DIA_E_MEDIA_NOT_FOUND;
                  break;
               case mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_INVALID_MEDIA:
                  testResult.mReturnValue = DIA_E_MEDIA_INVALID;
                  break;
               case mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_CANCELED:
                  testResult.mReturnValue = DIA_E_ROUTINE_ABORTED;
                  break;
               case mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_DEV_MMGR_BUSY:
                  testResult.mReturnValue = DIA_E_ROUTINE_BUSY;
                  break;
               default:
                  testResult.mReturnValue = DIA_FAILED;
                  break;
               }

               testResult.mSectorsRead = methodResultDriveTest.u32SectorsRead;
               testResult.mReadAttemps = methodResultDriveTest.u16ReadAttemps;
               testResult.mErrorCount = methodResultDriveTest.u16CntErrors;
               testResult.mAverageReadTimePerSector = methodResultDriveTest.u16AverageReadtimeSector;
               testResult.mTotalReadTime = methodResultDriveTest.u32TotalReadTime;
               testResult.mMaxReadTimePerSector = methodResultDriveTest.u16MaxReadTimePerSector;
               testResult.mMaxLBA = methodResultDriveTest.u32MaxLBA;
               testResult.mCntDVDLayer = methodResultDriveTest.u8CntDVDLayer;

               pListener->vOnCDDriveSelftest( duration, testResult );
               DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveTest vOnCDDriveSelftest FINISH." );
            }
         }
         else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
         {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF(" dia_SAFeatureVDMMGR --- opcode error received with error code: %d", u16ErrorCode );
         }
         else
         {
            DIA_TR_INF( "dia_SAFeatureVDMMGR --- OpCode = %d received", poMessage->u8GetOpCode() );
         }

      }  // else: no pointer to listener

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureVDMMGR::vHandleCDDriveMediaType( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::vHandleCDDriveMediaType()" );

#if 0
   if( poMessage )
   {
      DIA_ASSERT( poMessage->bIsServerMessage() == TRUE );

      dia_IVDMMGRListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IVDMMGRListener>( &pListener );
      if( pListener )
      {
         if( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
         {
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveMediaType AMT_C_U8_CCAMSG_OPCODE_STATUS" );

            dia_eOpticalDriveMediaType       MediaType;
            fi_tclVisitorMessage             oReceivedMsg( poMessage );
            midw_mmgrfi_tclMsgCDInfoStatus   oReceivedData;
            (tVoid)oReceivedMsg.s32GetData( oReceivedData );

            switch( oReceivedData.CDType.enType )
            {
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_INIT:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_NO_MEDIA;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_NO_MEDIA:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_NO_MEDIA;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_INSERTION:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_INSERTION;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_INCORRECT:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_INCORRECT;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_AUDIO:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_AUDIO;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_DATA:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_DATA;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_EJECTING:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_EJECTING;
                  break;
               case midw_fi_tcl_e8_CdType::FI_EN_MMGR_MEDIA_IN_SLOT:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_MEDIA_IN_SLOT;
                  break;
               default:
                  MediaType = DIA_EN_MMGR_CD_MEDIA_TYPE_UNKNOWN;
                  break;
            }
            // inform registered listeners
            pListener->vOnOpticalDriveMediaType( MediaType );
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveMediaType: Media type = %d.", MediaType );
         }
         else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
         {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF("dia_SAFeatureVDMMGR::vHandleCDDriveMediaType --- opcode error received with error code: %d", u16ErrorCode);
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureVDMMGR::vHandleCDDriveMediaType --- OpCode = %d received", poMessage->u8GetOpCode());
         }

      }  // else: no pointer to listener

      (tVoid) poMessage->bDelete();
   }
#endif
}
//-----------------------------------------------------------------------------

tVoid dia_SAFeatureVDMMGR::vHandleCDDriveLoaderStatus( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::vHandleCDDriveLoaderStatus()" );

   if( poMessage )
   {
      DIA_ASSERT( poMessage->bIsServerMessage() == TRUE );

      dia_IVDMMGRListener* pListener = OSAL_NULL;
      if( (querySysAdapterListener<dia_IVDMMGRListener>( &pListener ) == DIA_SUCCESS) && pListener )
      {
         if( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
         {
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveLoaderStatus AMT_C_U8_CCAMSG_OPCODE_STATUS" );

            dia_eOpticalDriveLoaderStatus          LoaderStatus;
            fi_tclVisitorMessage                   oReceivedMsg( poMessage );
            mplay_mmgrfi_tclMsgDiagLoadStatusStatus oReceivedData;
            (tVoid)oReceivedMsg.s32GetData( oReceivedData );

            switch( oReceivedData.LoadStatus.enType )
            {
               case mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_MEDIA_IN_SLOT:
                  LoaderStatus = DIA_EN_MMGR_CD_LOADER_STATUS_MEDIA_IN_SLOT;
                  break;
               case mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_NO_MEDIA_IN_DRIVE:
                  LoaderStatus = DIA_EN_MMGR_CD_LOADER_STATUS_NO_MEDIA_IN_DRIVE;
                  break;
               case mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_MEDIA_INSIDE:
                  LoaderStatus = DIA_EN_MMGR_CD_LOADER_STATUS_MEDIA_INSIDE;
                  break;
               case mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_EJECT_IN_PROGRESS:
                  LoaderStatus = DIA_EN_MMGR_CD_LOADER_STATUS_EJECT_IN_PROGRESS;
                  break;
               default:
                  LoaderStatus = DIA_EN_MMGR_CD_LOADER_STATUS_UNKNOWN;
                  break;
            }
            // inform registered listeners
            pListener->vOnOpticalDriveLoaderStatus( LoaderStatus );
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleCDDriveLoaderStatus: Loader status = %d.", LoaderStatus );
         }
         else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
         {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF("dia_SAFeatureVDMMGR::vHandleCDDriveLoaderStatus --- opcode error received with error code: %d", u16ErrorCode);
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureVDMMGR::vHandleCDDriveLoaderStatus --- OpCode = %d received", poMessage->u8GetOpCode());
         }

      }  // else: no pointer to listener

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureVDMMGR::vHandleControlEject( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::vHandleControlEject()" );

   if( poMessage )
   {
      DIA_ASSERT( poMessage->bIsServerMessage() == TRUE );

      dia_IVDMMGRListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IVDMMGRListener>( &pListener );
      if( pListener )
      {
         if( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
         {
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleControlEject AMT_C_U8_CCAMSG_OPCODE_METHODRESULT" );

            fi_tclVisitorMessage                             oReceivedMsg( poMessage );
            mplay_mmgrfi_tclMsgDiagControlEjectMethodResult  oReceivedData;
            (tVoid)oReceivedMsg.s32GetData( oReceivedData );

            mplay_fi_tcl_e16_DiagResultEject::tenType eReceivedResult = oReceivedData.ResultEject.e16Result.enType;
            DIA_TR_INF( "dia_SAFeatureVDMMGR::vHandleControlEject: Eject Result from MMGR = %d.", eReceivedResult );

            // inform registered listeners
            tDiaResult eDiaResult = (eReceivedResult == mplay_fi_tcl_e16_DiagResultEject::FI_EN_MMGR_EJECT_OK ) ? DIA_SUCCESS : DIA_FAILED;
            pListener->vOnControlEject( eDiaResult );
         }
         else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
         {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF("dia_SAFeatureVDMMGR::vHandleControlEject --- opcode error received with error code: %d", u16ErrorCode);
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureVDMMGR::vHandleControlEject --- OpCode = %d received", poMessage->u8GetOpCode());
         }

      }  // else: no pointer to listener

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureVDMMGR::vHandleSelectTrackType( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureVDMMGR::vHandleSelectTrackType" );

   if( poMessage )
   {
      // Extract the operation code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
         case CCA_C_U8_OPCODE_METHODRESULT:
         {
            DIA_TR_INF(( "ddia_SAFeatureVDMMGR::vHandleSelectTrackType - Received MethodResult: SelectTrackType" ));

            fi_tclVisitorMessage                                  oReceivedMsg( poMessage );
            mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult  oReceivedData;
            (tVoid)oReceivedMsg.s32GetData( oReceivedData );
            dia_IVDMMGRListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IVDMMGRListener>(&pListener);
            if( pListener )
            {
               DIA_TR_INF(( "dia_SAFeatureVDMMGR::vHandleSelectTrackType: call vOnCDModeChangeResultMMgr( )" ));
               tDiaResult eDiaResult = (oReceivedData.Result.enType == mplay_fi_tcl_e8_TrackTypeResult::FI_EN_OK) ? DIA_SUCCESS : DIA_FAILED;
               pListener->vOnCDModeChangeResultMMgr( eDiaResult );
            }
            break;
         }
         default:
            DIA_TR_INF(( "dia_SAFeatureDeviceMGR::vHandleSelectTrackType - OpCode not ok" ));
            break;
      }
      // Delete the message we are unable process it at this time
      (void) poMessage->bDelete();
   }  // if( poMessage )
}

