/*
 * dia_SAFeatureTunerXMControl.cpp
 *
 *  Created on: 14.12.2012
 *      Author: shw2abt
 */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SAFeatureTunerXMControl.h"

#define DIAGLIB_INCLUDE_IO_CONTROL
#include "common/diaglib/diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

/*
#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif
*/

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_STDVISITORS
#include "midw_ext_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerXMControl,dia_SystemAdapterFeatureDiaglib)
//   ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_CHANNELINFORMATION,     vHandleTunerXM_1_ChannelInformation)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureTunerXMControl::dia_SAFeatureTunerXMControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXMControl::dia_SAFeatureTunerXMControl");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTunerXMControl::~dia_SAFeatureTunerXMControl ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerXMControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_TUNERXM_CHANNEL);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerXMControl::TunerXMControl_1_Channel_Set ( tU8 channel )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXMControl::TunerXMControl_1_Channel_Set()");
   tDiaResult retCode = DIA_FAILED;

//   Diaglib Feature
//   /* number of XM tuner channel */
//   #define IOCONTROLID_TUNERXM_CHANNEL 20
//   #define IOCONTROLID_TUNERXM_CHANNEL_SET_u8XMchannel 0
//   #define IOCONTROLID_TUNERXM_CHANNEL_SET_PARAM1 (tU8)2
//   #define IOCONTROLID_TUNERXM_CHANNEL_SET_LEN (tU8)1
//   #define IOCONTROLID_TUNERXM_CHANNEL_RESULT_u8XMchannel 0
//   #define IOCONTROLID_TUNERXM_CHANNEL_RESULT_PARAM1 (tU8)2
//   #define IOCONTROLID_TUNERXM_CHANNEL_RESULT_LEN (tU8)1


   DIA_TR_INF("dia_SAFeatureTunerXMControl::TunerXMControl_1_Channel_Set - frame Diaglib parameter vector");

   tDiaglibParamVector vecRequest;
   trParameter paramXMchannel;

   paramXMchannel.enType = static_cast<tenParameterType>(IOCONTROLID_TUNERXM_CHANNEL_SET_PARAM1);
   paramXMchannel.u8Value = channel;

   DIA_TR_INF("dia_SAFeatureTunerXMControl::TunerXMControl_1_Channel_Set - Diaglib: XM channel: 0x%02x", channel);
   vecRequest.push_back(paramXMchannel);

   if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_TUNERXM_CHANNEL, EN_ACTION_SET, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureTunerXMControl::TunerXMControl_1_Channel_Set - bIOControlStart - SUCCESS.");
   } else {
      DIA_TR_INF("dia_SAFeatureTunerXMControl::TunerXMControl_1_Channel_Set - bIOControlStart - FAILED.");
   }

   return retCode;
}

//==========================================================================================================================================
//==========================================================================================================================================

tVoid
dia_SAFeatureTunerXMControl::vHandleIOControl ( amt_tclServiceData* poMessage ){
   dia_tclFnctTrace trc("dia_SAFeatureTunerXMControl::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerXMControl::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction /*enActionId*/, const tDiaglibParamVector& /*oStartResult*/){
   dia_tclFnctTrace trc("dia_SAFeatureTunerXMControl::vOnIoCtrlResult()");
   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32IoCtrlId);

   dia_ITunerXMControlListener* pTunerXMControlListener = OSAL_NULL;
   querySysAdapterListener<dia_ITunerXMControlListener>(&pTunerXMControlListener);

   if (pTunerXMControlListener) {
      DIA_TR_INF("dia_SAFeatureTunerXMControl::vOnIoCtrlResult - pTunerXMListener OK.");
      if (enResult == EN_IO_CONTROL_OK) {
         DIA_TR_INF("dia_SAFeatureTunerXMControl::vOnIoCtrlResult - EN_IOCONTROL__OK !!");
         pTunerXMControlListener->vOnTunerXMControl_1_Channel_Set(DIA_SUCCESS);
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXMControl::vOnIoCtrlResult - EN_IOCONTROL_NOK !!");
         pTunerXMControlListener->vOnTunerXMControl_1_Channel_Set(DIA_FAILED);
      }

   } else {
      DIA_TR_ERR("dia_SAFeatureTunerXMControl::vOnIoCtrlResult - No listener registered");
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerXMControl::vHandleTunerXMControl_1_Channel_Set ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXMControl::vHandleTunerXMControl_1_Channel_Set()");
   DIA_TR_INF("dia_SAFeatureTunerXMControl::vHandleTunerXMControl_1_Channel_Set - not implemented - not implemented - not implemented - not implemented.");

   // TODO - poMessage einkommentieren

}
