/*
 * dia_SAFeatureTunerXM.h
 *
 *  Created on: 15.11.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURETUNERXM_H_
#define DIA_SAFEATURETUNERXM_H_

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/framework/application/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERXM_LISTENER__
#include "common/interfaces/dia_ITunerXMListener.h"
#endif

#define CHANNEL_LABEL_MAXLEN 16
#define UPC_RESPONSELENGTH 13

#define BASE_TEN ((tU8)0x10)

class dia_SAFeatureTunerXM
   : public dia_SystemAdapterFeature,
     public dia_ITunerXM
{
public:
   //! constructor
   dia_SAFeatureTunerXM ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTunerXM ( tVoid );

   //----------------------------------------------------------------------
   // Interface dia_ITunerXM
   //----------------------------------------------------------------------

   //! Function from SH to SA to read the XM channel.
   virtual tDiaResult tunerXM_1_Channel_Get ( tVoid );
   //! Function from SH to SA to read the XM channel label.
   virtual tDiaResult tunerXM_1_ChannelLabel_Get ( tVoid );
   //! Function from SH to SA to read the XM signal quality.
   virtual tDiaResult tunerXM_1_SignalQuality_Get ( tVoid );
   //! Function from SH to SA to read the XM antenna 1 status.
   virtual tDiaResult tunerXM_1_Antenna1Status_Get ( tVoid );
   //! Function from SH to SA to read the XM UPC code
   virtual tDiaResult tunerXM_XM_UPC_Get ( tVoid );
   //! Function from SH to SA to start the SXM software update
   virtual tDiaResult tunerXM_startSWUpdate (  );
   //! Function from SH to SA to read the current update status
//   virtual tDiaResult tunerXM_getSWUpdateStatus (  );
   //! Function from SH to SA to set the DiagTestModeEnable
   virtual tDiaResult tunerXM_DiagTestModeEnable_Set ( tBool bEnable );
   //! Function from SH to SA to set the DiagTestModeData
   virtual tDiaResult tunerXM_DiagTestModeData_Get ( );


protected:
   //! deprecated default constructor
   dia_SAFeatureTunerXM ( tVoid );

   //--------------------------------------------------------------------------
   // Handlers for incoming messages
   //--------------------------------------------------------------------------

   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

//   tVoid vHandleTunerXM_1_Channel_Set         ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerXM_1_ChannelInformation  ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerXM_1_SignalQuality_Get   ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerXM_1_Antenna1Status_Get  ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerXM_XM_UPC_Get            ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerSWUpdateComplete         ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerSWUpdateStatus           ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerDiagTestModeEnable_Set   ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleTunerXM_DiagTestModeData_Get  ( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTunerXM)
};

#endif /* DIA_SAFEATURETUNERXM_H_ */
