/*
 * dia_SAFeatureTunerXM.cpp 
 *
 *  Created on: 15.11.2012
 *      Author: shw2abt
 */

#include "dia_SAFeatureTunerXM.h"
#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_STDVISITORS
#include "midw_ext_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerXM,dia_SystemAdapterFeature)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGSIGNALQUALITY, vHandleTunerXM_1_SignalQuality_Get)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGANTENNASTATE, vHandleTunerXM_1_Antenna1Status_Get)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_CHANNELINFORMATION, vHandleTunerXM_1_ChannelInformation)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGUPCVALUES, vHandleTunerXM_XM_UPC_Get)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOAD, vHandleTunerSWUpdateComplete)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOADPROGRESS,vHandleTunerSWUpdateStatus)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEENABLE, vHandleTunerDiagTestModeEnable_Set)
ON_MESSAGE(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEDATA,vHandleTunerXM_DiagTestModeData_Get)
END_MSG_MAP()

using namespace std;

//------------------------------------------------------------------------------

dia_SAFeatureTunerXM::dia_SAFeatureTunerXM (
      tCString name,// feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
)
: dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::dia_SAFeatureTunerXM");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTunerXM::~dia_SAFeatureTunerXM(tVoid)
{
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTunerXM::tunerXM_1_Channel_Get(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - send message.");
      gm_tclEmptyMessage oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), MIDW_EXT_SXM_AUDIOFI_C_U16_CHANNELINFORMATION,
            CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get - send message.");
      gm_tclEmptyMessage oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), MIDW_EXT_SXM_AUDIOFI_C_U16_CHANNELINFORMATION,
            CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_ChannelLabel_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get - send message.");
      gm_tclEmptyMessage oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGSIGNALQUALITY,
            CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_SignalQuality_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTunerXM::tunerXM_1_Antenna1Status_Get(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_1_Antenna1Status_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGANTENNASTATE,
            CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_1_Channel_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get - send message.");

      midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart oData;

      oData.GetVal = UPC_GET_VALUE;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGUPCVALUES, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_XM_UPC_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

#define arU8_2_szValue(arU8, arU8_Length, target_szValue)  \
      tString tmp = OSAL_NEW tChar[arU8_Length]; \
      if ( tmp ) { \
         strcpy(tmp,(char*)arU8); \
         target_szValue.szValue = tmp; \
      }

tDiaResult dia_SAFeatureTunerXM::tunerXM_startSWUpdate()
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_startSWUpdate()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - send message.");

      midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart oData;

#ifndef __ENABLE_FEATURE_NISSAN_TUNERXM_UPDATE_TESTMODE__
//    write dummy values in structure
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - use predefined values.");
      oData.File    = "/var/opt/bosch/static/siriusxm/C65firmware_X65H2i_v9.12.132.bin";
      oData.Version = "x09-0c-84";
#else
//    read data from registry
      tU8 propValue[DIA_PROP_LENGTH_MAX_REG] = {0};
      tU16 propDataLength = SXM_SW_STRING_PROP_LEN;

      if(dia_ConfigManager::getProperty(DIA_PROP_CM_SXM_SW_DOWNLOAD_STRING, &propValue[0], &propDataLength)==DIA_SUCCESS ){
         arU8_2_szValue(propValue, propDataLength, oData.File);
      } else {
         DIA_TR_ERR("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - DOWNLOAD_STRING reading failed.");
      }
      (tVoid) ::memset(propValue,0,DIA_PROP_LENGTH_MAX_REG);
      propDataLength = SXM_SW_STRING_PROP_LEN;
      if (dia_ConfigManager::getProperty(DIA_PROP_CM_SXM_SW_DOWNLOAD_VERSION, &propValue[0], &propDataLength)==DIA_SUCCESS )
      {
         arU8_2_szValue(propValue, propDataLength, oData.Version);
      } else {
         DIA_TR_ERR("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - DOWNLOAD_VERSION reading failed.");
      }
#endif

      oData.bForced = TRUE;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(
            oMessage,
            MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOAD,
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART
            );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - transmitMessage START success.");
         DIA_TR_INF("dia_SAFeatureTunerXM:: - File: %s .",oData.File.szValue);
         DIA_TR_INF("dia_SAFeatureTunerXM:: - Vers: %s .",oData.Version.szValue);

         // Add additionally the UPREG for the status
         gm_tclEmptyMessage oMessage_UPREG(
               mAppID,
               mpSrvPlugin->getClientID(),
               mpSrvPlugin->getRegistrationID(),
               0,
               mpSrvPlugin->getServiceID(),
               MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOADPROGRESS,
               CCA_C_U8_OPCODE_UPREG
               );

         if (mpSrvPlugin->bTransmitMessage(&oMessage_UPREG) == TRUE) {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - transmitMessage UPREG success.");
         } else {
            DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - transmitMessage UPREG failed!");
         }
      } else {
         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - transmitMessage START failed!");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_startSWUpdate - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set ( tBool bEnable )
{
	dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set()");
	tDiaResult retCode = DIA_FAILED;

	if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
	{
		midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart oData;
		oData.bEnable = bEnable;

		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set - bEnable=%d ", oData.bEnable);

		//put the data in message
		fi_tclVisitorMessage oMessage(oData);
		mpSrvPlugin->vInitServiceData(oMessage, MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEENABLE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

		if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
		{
		retCode = DIA_SUCCESS;
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set - transmitMessage success.");
		}
		else
		{
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set - transmitMessage failed.");
		}
	}
	else
	{
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set - getRegistrationID failed.");
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeEnable_Set - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	}
	return retCode;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get ( )
{
	dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get()");
	tDiaResult retCode = DIA_FAILED;

	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
	{
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get - send message.");
		gm_tclEmptyMessage oMessage (
		mAppID,
		mpSrvPlugin->getClientID(),
		mpSrvPlugin->getRegistrationID(),
		0,
		mpSrvPlugin->getServiceID(),
		MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEDATA,
		CCA_C_U8_OPCODE_GET
		);

		if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
		retCode = DIA_SUCCESS;
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get - transmitMessage success.");
		} else {
		DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get - transmitMessage failed.");
		}
	} else {
	DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get - getRegistrationID failed.");
	DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_DiagTestModeData_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	}

	return retCode;
}

//-----------------------------------------------------------------------------


//tDiaResult dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus()
//{
//   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus()");
//   tDiaResult retCode = DIA_FAILED;
//
//   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
//      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus - send message.");
//      gm_tclEmptyMessage oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOADPROGRESS,
//            CCA_C_U8_OPCODE_GET);
//
//      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
//         retCode = DIA_SUCCESS;
//         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus - transmitMessage success.");
//      } else {
//         DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus - transmitMessage failed.");
//      }
//
//   } else {
//      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus - getRegistrationID failed.");
//      DIA_TR_INF("dia_SAFeatureTunerXM::tunerXM_getSWUpdateStatus - getRegistrationID == AMT_C_U16_REGID_INVALID.");
//   }
//
//   return retCode;
//}

//==========================================================================================================================================
//==========================================================================================================================================

/*
 * Handles response for
 * - tunerXM_1_Channel_Get
 * - tunerXM_1_ChannelLabel_Get
 */tVoid dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeaturetunerXM_1::vHandleTunerXM_1_ChannelInformation()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_sxm_audiofi_tclMsgChannelInformationStatus oCompResp;

            (tVoid) oResultMsg.s32GetData(oCompResp);

            // tunerXM_1_Channel_Get
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation active Channel: %d",oCompResp.ChannelInformation.ChannelNumber);
            pListener->vOnTunerXM_1_Channel_Get((tU8) oCompResp.ChannelInformation.ChannelNumber);

            // size of channel label address string
            tString str_channelName = oCompResp.ChannelInformation.ChannelName.szGet(midw_ext_fi_tclString::FI_EN_UTF8);
            midw_ext_fi_tclString midw_str_channelName = oCompResp.ChannelInformation.ChannelName;
            tU32 channelLabel_Size = midw_str_channelName.u32GetSize();
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation size Channel Label Size  : %d",channelLabel_Size);
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation size Channel Label String_str: %s",str_channelName);

            // tunerXM_1_ChannelLabel_Get
            char arChannelLabel[CHANNEL_LABEL_MAXLEN] = { 0 };
            char arChannelLabel2[CHANNEL_LABEL_MAXLEN] = { 0 };
            if (channelLabel_Size) {
              // (tVoid) OSAL_szStringCopy(arChannelLabel, midw_str_channelName);
               //(tVoid) OSAL_szStringCopy(arChannelLabel2, str_channelName);
            	(void) ::memcpy(arChannelLabel,midw_str_channelName,CHANNEL_LABEL_MAXLEN);//CoverityFix(CID:28726)
            	(void) ::memcpy(arChannelLabel2,str_channelName,CHANNEL_LABEL_MAXLEN);
            }
//            arChannelLabel[channelLabel_Size] = '\0';

            for (tU8 i = 0; i < channelLabel_Size; i++) {
               DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation Channel Label Array[%d]=0x%02x ; %c",i,arChannelLabel[i],arChannelLabel[i]);
            }
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation ===========================================");
            for (tU8 i = 0; i < channelLabel_Size; i++) {
               DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation Channel Label Array2[%d]=0x%02x ; %c",i,arChannelLabel2[i],arChannelLabel2[i]);
            }
            pListener->vOnTunerXM_1_ChannelLabel_Get(arChannelLabel, channelLabel_Size);

            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation DONE!");
         }

      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureTunerXM::ChannelInformation - opcode error received with error code:%u",u16ErrorCode);
      }
      DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_1_ChannelInformation FINISH! ...................................");
      (tVoid) poMessage->bDelete();
   }

}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTunerXM::vHandleTunerXM_1_SignalQuality_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerXM_1_SignalQuality_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            tU8 signalQuality = SIGNAL_STATUS_UNKNOWN;
            switch (oCompResp.SignalQualityStatus.enType) {
               case midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_NO_SIGNAL:
                  // TODO
                  signalQuality = midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_NO_SIGNAL;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_WEAK_SIGNAL:
                  signalQuality = midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_WEAK_SIGNAL;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_GOOD_SIGNAL:
                  signalQuality = midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_GOOD_SIGNAL;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_EXCELLENT_SIGNAL:
                  signalQuality = midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_EXCELLENT_SIGNAL;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_INVALID_SIGNAL:
                  signalQuality = midw_ext_fi_tcl_e8_Sxm_SignalQuality::FI_EN_FC_SXM_DIAG_SQ_INVALID_SIGNAL;
                  break;
               default:
                  DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerXM_1_SignalQuality_Get UNKNOWN SignalQuality !!!");
                  break;
            }

            pListener->vOnTunerXM_1_SignalQuality_Get(signalQuality);
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureTunerXM --- opcode error received with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }

}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTunerXM::vHandleTunerXM_1_Antenna1Status_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerXM_1_Antenna1Status_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            tU8 antennaStatus = DIA_EN_TUNERXM_ANTENNASTATUS_UNKNOWN; //Coverity fix(CID:52797)
            switch (oCompResp.AntennaStatus.enType) {
               case midw_ext_fi_tcl_e8_Sxm_AntennaState::FI_EN_FC_SXM_DIAG_ANT_UNKNOWN:
                  antennaStatus = DIA_EN_TUNERXM_ANTENNASTATUS_UNKNOWN;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_AntennaState::FI_EN_FC_SXM_DIAG_ANT_DETECTED:
                  antennaStatus = DIA_EN_TUNERXM_ANTENNASTATUS_OK;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_AntennaState::FI_EN_FC_SXM_DIAG_ANT_NOT_DETECTED:
                  antennaStatus = DIA_EN_TUNERXM_ANTENNASTATUS_OPEN;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_AntennaState::FI_EN_FC_SXM_DIAG_ANT_SHORTED:
                  antennaStatus = DIA_EN_TUNERXM_ANTENNASTATUS_SHORT_GROUND;
                  break;
               case midw_ext_fi_tcl_e8_Sxm_AntennaState::FI_EN_FC_SXM_DIAG_ANT_UNSUPPORTED:
                  antennaStatus = DIA_EN_TUNERXM_ANTENNASTATUS_NOT_SUPPORTED;
                  break;
               default:
                  DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerXM_1_SignalQuality_Get UNKNOWN AntennaState !!!");
                  break;
            }

            pListener->vOnTunerXM_1_Antenna1Status_Get(antennaStatus);
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureTunerXM --- opcode error received with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTunerXM::vHandleTunerXM_XM_UPC_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerXM_XM_UPC_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT) {
         dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            if (oCompResp.UpcLid0.u32GetSize() != UPC_RESPONSELENGTH || oCompResp.UpcLid1.u32GetSize() != UPC_RESPONSELENGTH) {
               DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerXM_XM_UPC_Get UpcLid0 RESPONSE LENGTH IST:%d SOLL:%d",oCompResp.UpcLid0.u32GetSize(),UPC_RESPONSELENGTH);
               DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerXM_XM_UPC_Get UpcLid1 RESPONSE LENGTH IST:%d SOLL:%d",oCompResp.UpcLid1.u32GetSize(),UPC_RESPONSELENGTH);
               return;
            }
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_XM_UPC_Get UpcLid0: %s",oCompResp.UpcLid0.szValue);
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_XM_UPC_Get UpcLid1: %s",oCompResp.UpcLid1.szValue);

            // Input format is "123456789abc" -> should result in (0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc) byte array
            string lid0Msb(oCompResp.UpcLid0.szValue, oCompResp.UpcLid0.szValue + SXM_UPC_BYTE_SIZE);
            long baseMsb = ::strtol(lid0Msb.c_str(), 0, 16);
            string lid0Lsb(oCompResp.UpcLid0.szValue + SXM_UPC_BYTE_SIZE);
            long baseLsb = ::strtol(lid0Lsb.c_str(), 0, 16);
            string lid1Msb(oCompResp.UpcLid1.szValue, oCompResp.UpcLid1.szValue + SXM_UPC_BYTE_SIZE);
            long overlayMsb = ::strtol(lid1Msb.c_str(), 0, 16);
            string lid1Lsb(oCompResp.UpcLid1.szValue + SXM_UPC_BYTE_SIZE);
            long overlayLsb = ::strtol(lid1Lsb.c_str(), 0, 16);

            tU8 base[SXM_UPC_BYTE_SIZE] = { 0 };
            tU8 overlay[SXM_UPC_BYTE_SIZE] = { 0 };

            for (int i = SXM_UPC_BYTE_SIZE; i > 0; --i)
            {
               base[i-1] = (tU8)(baseLsb & 0xFF);
               overlay[i-1] = (tU8)(overlayLsb & 0xFF);
               baseLsb >>= 8;
               overlayLsb >>= 8;
            }
            for (int i = SXM_UPC_BYTE_SIZE/2; i > 0; --i)
            {
               base[i-1] = (tU8)(baseMsb & 0xFF);
               overlay[i-1] = (tU8)(overlayMsb & 0xFF);

               baseMsb >>= 8;
               overlayMsb >>= 8;
            }

            pListener->vOnTunerXM_XM_UPC_Get(base, overlay);
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureTunerXM --- opcode error received with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }

}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT) {
         dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);

            midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            switch (oCompResp.enResult.enType) {
               case midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::FI_EN_NOERROR:
                  DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete Successful .");
                  pListener->vOnTunerXM_SWUpdateComplete(DIA_SUCCESS);
                  break;
               case midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::FI_EN_FILENOTFOUND:
               case midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::FI_EN_INVALIDVERSION:
               case midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::FI_EN_ABORTED:
               case midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::FI_EN_BUSY:
               case midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::FI_EN_UNKNOWNERROR:
                  DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete Failed.");
                  pListener->vOnTunerXM_SWUpdateComplete(DIA_FAILED);
                  break;
               default:
                  DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete UNKNOWN enResult.enType!");
                  break;
            }
         }

         // Remove additionally the UPREG for the status
         gm_tclEmptyMessage oMessage(
               mAppID,
               mpSrvPlugin->getClientID(),
               mpSrvPlugin->getRegistrationID(),
               0,
               mpSrvPlugin->getServiceID(),
               MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOADPROGRESS,
               CCA_C_U8_OPCODE_RELUPREG);

         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete - transmitMsg RELUPREG success.");
         } else {
            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete - transmitMsg RELUPREG failed!");
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerSWUpdateComplete --- opcode error: 0x%04x",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTunerXM::vHandleTunerSWUpdateStatus(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerSWStatus()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerSWUpdateStatus active=%d (1==TRUE) progress=%d (0x%02x).",oCompResp.bActive,oCompResp.Progress,oCompResp.Progress);

            pListener->vOnTunerXM_SWUpdateStatus(oCompResp.bActive, oCompResp.Progress);
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerXM::vHandleTunerSWUpdateStatus --- opcode error: 0x%04x",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}

tVoid
dia_SAFeatureTunerXM::vHandleTunerDiagTestModeEnable_Set ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerDiagTestModeEnable_Set");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerDiagTestModeEnable_Set poMessage OK.");

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
    	  dia_ITunerXMListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerXMListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

               DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerDiagTestModeEnable_Set SUCCESS!");
               pListener->vOnTunerXM_DiagTestModeEnable_Set(DIA_SUCCESS);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR("dia_SAFeatureTunerAMFM --- opcode error received with error code: %d", u16ErrorCode);
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerDiagTestModeEnable_Set UnknownOpCode=%d!", poMessage->u8GetOpCode());
      }

      (tVoid) poMessage->bDelete();
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerDiagTestModeEnable_Set poMessage EMPTY!");
   }
}

//-----------------------------------------------------------------------------
tVoid
dia_SAFeatureTunerXM::vHandleTunerXM_DiagTestModeData_Get ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerXM::vHandleTunerXM_DiagTestModeData_Get");

	if (poMessage) {
	DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

	if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
	 dia_ITunerXMListener* pListener = OSAL_NULL;
	  if ((querySysAdapterListener<dia_ITunerXMListener>(&pListener) == DIA_SUCCESS) && pListener) {
	    fi_tclVisitorMessage oResultMsg(poMessage);
	    midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus oCompResp;

	   (tVoid) oResultMsg.s32GetData(oCompResp);

	   tU32 BERS1 = 0;
	   tU32 BERS2 = 0;
	   tU32 BERT = 0;
      DIA_TR_INF("BERS1='%s', BERS2='%s', BERT='%s'", oCompResp.Data.DetSignalQuality.BerS1.szValue,
            oCompResp.Data.DetSignalQuality.BerS2.szValue,
            oCompResp.Data.DetSignalQuality.BerT.szValue);
	   sscanf(oCompResp.Data.DetSignalQuality.BerS1.szValue, "%u", &BERS1);
	   sscanf(oCompResp.Data.DetSignalQuality.BerS2.szValue, "%u", &BERS2);
	   sscanf(oCompResp.Data.DetSignalQuality.BerT.szValue, "%u", &BERT);

	   pListener->vOnTunerXM_DiagTestModeData_Get(tU16(BERS1 * 10), tU16(BERS2 * 10), tU16(BERT * 10));
	}

	} else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
	amt_tclServiceDataError oErrorMsg(poMessage);
	tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
	DIA_TR_INF("dia_SAFeatureTunerXM::vHandleTunerXM_DiagTestModeData_Get - opcode error received with error code:%u",u16ErrorCode);
	}
	(tVoid) poMessage->bDelete();
	}
}
