/*
 * dia_SAFeatureTunerTestmode.cpp
 *
 *  Created on: 09.05.2017
 *      Author: stc2hi
 *
 *--------------------------------------------------------
 * Date        | Author        | Modification
 *************************************************************************/

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SAFeatureTunerTestmode.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS

#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerTestmode,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_TESTMODE,             vHandleTestmodeStartResult)
   ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS, vHandleTestmodeData)
END_MSG_MAP()


//------------------------------------------------------------------------------

dia_SAFeatureTunerTestmode::dia_SAFeatureTunerTestmode (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerTestmode::dia_SAFeatureTunerTestmode");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTunerTestmode::~dia_SAFeatureTunerTestmode ( void )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerTestmode::controlTestmode(tBool bControl)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerTestmode::controlTestmode");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart oData;
      oData.e8TestModeSource.enType = midw_fi_tcl_e8_Tun_TestModeSource::FI_EN_TUN_TEST_MODE_SOURCE_ANALOG_AMFM;
      oData.e8TestModeActivity.enType = (bControl == TRUE)?
            midw_fi_tcl_e8_Tun_TestModeActivity::FI_EN_TUN_TEST_MODE_NOTIFICATION_ON:
            midw_fi_tcl_e8_Tun_TestModeActivity::FI_EN_TUN_TEST_MODE_NOTIFICATION_OFF;

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERFI_C_U16_FID_TUN_S_SET_TESTMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;

         if (bControl == TRUE)
         {
            if(mpSrvPlugin->bRegisterForFID(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS) == TRUE)//Coverity Fix -90892
            {
                DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - Register For FID success.");
				retCode = DIA_SUCCESS;
            }
            else
            {
                DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - Register For FID failed.");
				retCode = DIA_FAILED;
            }
         }
         else
         {
            if(mpSrvPlugin->bUnregisterForFID(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS) == TRUE)
            {
            	 DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - UnRegister For FID success.");
				 retCode = DIA_SUCCESS;
            }
            else
            {
           	     DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - UnRegister For FID failed.");
				 retCode = DIA_FAILED;
            }
         }

         DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerTestmode::controlTestmode - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTunerTestmode::vHandleTestmodeStartResult(amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerTestmode::vHandleTestmodeStartResult");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_ITunerTestmodeListener* pListener = OSAL_NULL;
         if ((querySysAdapterListener<dia_ITunerTestmodeListener>(&pListener) == DIA_SUCCESS) && pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult oCompResp;
            if (OSAL_OK == oResultMsg.s32GetData(oCompResp))
            {
               DIA_TR_INF("u8TunerStatus: 0x%x", oCompResp.TunerServer_StatusResponse.u8TunerStatus.enType);
               DIA_TR_INF("u8TunerState: 0x%x", oCompResp.TunerServer_StatusResponse.u8TunerState.enType);

               if ((oCompResp.TunerServer_StatusResponse.u8TunerStatus.enType == midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED) &&
                     (oCompResp.TunerServer_StatusResponse.u8TunerState.enType == midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL))
               {
                  pListener->vOnControlTestmode();
               }
            }
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
         amt_tclServiceDataError oErrorMsg( poMessage );
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("vHandleTestmodeStartResult --- opcode error received with error code: %d", u16ErrorCode);
      }
      else
      {
         DIA_TR_ERR("vHandleTestmodeStartResult poMessage->u8GetOpCode() UNKNOWN => CODE==%d!", poMessage->u8GetOpCode());
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTunerTestmode::vHandleTestmodeData ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerTestmode::vHandleTestmodeData");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_ITunerTestmodeListener* pListener = OSAL_NULL;
         if ((querySysAdapterListener<dia_ITunerTestmodeListener>(&pListener) == DIA_SUCCESS) && pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus oCompResp;
            if (OSAL_OK == oResultMsg.s32GetData(oCompResp))
            {
               DIA_TR_INF("Tuner: %x, Band: %x, f = %d, FS: 0x%x, MP: 0x%x, Q: 0x%x",
                     oCompResp.TunerTestModeData.u8PhysicalTuner.enType,
                     oCompResp.TunerTestModeData.u8Source.enType,
                     oCompResp.TunerTestModeData.u32AFFrequency,
                     oCompResp.TunerTestModeData.u8Fieldstrength,
                     oCompResp.TunerTestModeData.u8Multipath,
                     oCompResp.TunerTestModeData.u8Quality);

               dia_ITunerTestmodeData data;
               data.ePhysicalTuner = DIA_EN_AMFMTUNER_UNKNOWN;
               switch (oCompResp.TunerTestModeData.u8PhysicalTuner.enType)
               {
                  case midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_TUNER_0:
                     data.ePhysicalTuner = DIA_EN_AMFMTUNER_1;
                     break;
                  case midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_TUNER_1:
                     data.ePhysicalTuner = DIA_EN_AMFMTUNER_2;
                     break;
                  case midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_TUNER_2:
                     data.ePhysicalTuner = DIA_EN_AMFMTUNER_3;
                     break;
                  case midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_TUNER_3:
                     //Tuner4 is normally not an AM/FM Tuner
                     data.ePhysicalTuner = DIA_EN_AMFMTUNER_UNKNOWN;
                     break;
                  default:
                     break;
               }

               data.eBand = DIA_EN_AMFMTUNER_BAND_UNKNOWN;
               switch (oCompResp.TunerTestModeData.u8Source.enType)
               {
                  case midw_fi_tcl_e8_Tun_Testmode_TunerBand::FI_EN_TUN_BAND_FM:
                     data.eBand = DIA_EN_AMFMTUNER_BAND_FM;
                     break;
                  case midw_fi_tcl_e8_Tun_Testmode_TunerBand::FI_EN_TUN_BAND_AM:
                     data.eBand = DIA_EN_AMFMTUNER_BAND_AM;
                     break;
                  default:
                     break;
               }
               data.u32AFFrequency = oCompResp.TunerTestModeData.u32AFFrequency;
               data.u8Fieldstrength = oCompResp.TunerTestModeData.u8Fieldstrength;
               data.u8Multipath = oCompResp.TunerTestModeData.u8Multipath;
               data.u8Quality = oCompResp.TunerTestModeData.u8Quality;

               pListener->vOnTestmodeData(data);
            }
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
         amt_tclServiceDataError oErrorMsg( poMessage );
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("vHandleTestmodeData --- opcode error received with error code: %d", u16ErrorCode);
      }
      else
      {
         DIA_TR_ERR("vHandleTestmodeData poMessage->u8GetOpCode() UNKNOWN => CODE==%d!", poMessage->u8GetOpCode());
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------
