/*
 * dia_SAFeatureTunerMasterControl.h
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURETUNERMASTERCONTROL_H_
#define DIA_SAFEATURETUNERMASTERCONTROL_H_

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERMASTERCONTROL_LISTENER__
#include "common/interfaces/dia_ITunerMasterControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTunerMasterControl
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_ITunerMasterControl,
     public dia_IDiaglibRoutineControlListener
{
public:
   //! constructor
   dia_SAFeatureTunerMasterControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTunerMasterControl ( tVoid );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual tVoid vOnRoutineCtrlResult(
         tU32 u32RoutineId,
         tenRoutineCtrlResult enRoutineStatus,
         const tDiaglibParamVector& oStartResult
   );

   virtual tVoid vOnGetRoutineResult(
         tU32 u32RoutineId,
         tenRoutineCtrlResult enRoutineStatus,
         const tDiaglibParamVector& oRoutineResult
   ) {
      DIA_PARAMETER_INTENTIONALLY_UNUSED(u32RoutineId);
      DIA_PARAMETER_INTENTIONALLY_UNUSED(enRoutineStatus);
      DIA_PARAMETER_INTENTIONALLY_UNUSED(oRoutineResult);
   }

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ITunerAMFM methods
   //
   //-------------------------------------------------------------------------

   //! enable and disable the antenna phantom power supply of antenna AM/FM1
   virtual tDiaResult tunerAMFM_TunerPowerSupply_Set ( dia_eTunerMasterControlPowerSupply powerSupply );
   virtual tDiaResult tunerAMFM_TunerAntenna2PowerSupply_Set ( dia_eTunerMasterControlPowerSupply powerSupply );
   virtual tDiaResult tunerDAB_TunerPowerSupply_Set  ( dia_eTunerMasterControlEnableMode powerMode );

protected:
   //! deprecated default constructor
   dia_SAFeatureTunerMasterControl ( tVoid );

   //! handle incoming CCA message
   tVoid vHandleRoutineControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTunerMasterControl)
};

#endif /* DIA_SAFEATURETUNERMASTERCONTROL_H_ */
