/*
 * dia_SAFeatureTunerDABControl.h
 *
 *  Created on: 10.07.2013
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURETUNERDABCONTROL_H_
#define DIA_SAFEATURETUNERDABCONTROL_H_

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDABCONTROL_LISTENER__
#include "common/interfaces/dia_ITunerDABControlListener.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "common/framework/sysadapters/dia_SystemAdapterFeatureDiaglib.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTunerDABControl
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_ITunerDABControl,
     public dia_IDiaglibIoControlListener
{
public:
   //! constructor
   dia_SAFeatureTunerDABControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTunerDABControl ( void );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual void vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ITunerDABControl methods
   //
   //-------------------------------------------------------------------------

   virtual tDiaResult tunerDAB_EnsembleFrequency_Set ( tU32 frequency );
   virtual tDiaResult tunerDAB_ServiceID_Set  ( tU32 serviceID );

protected:
   //! deprecated default constructor
   dia_SAFeatureTunerDABControl ( void );

   //! handle incoming CCA message
   void vHandleIOControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTunerDABControl)
};


#endif /* DIA_SAFEATURETUNERDABCONTROL_H_ */
