/*
 * dia_SAFeatureTunerDAB.h
 *
 *  Created on: 20.11.2013
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURETUNERDAB_H_
#define DIA_SAFEATURETUNERDAB_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDAB__
#include "common/interfaces/dia_ITunerDAB.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDAB_LISTENER__
#include "project/interfaces/dia_ITunerDABListener.h"
#endif

#define CHANNEL_LABEL_MAXLEN 16
#define UPC_RESPONSELENGTH 13

class dia_SAFeatureTunerDAB
   : public dia_SystemAdapterFeature,
     public dia_ITunerDAB
{
public:
   //! constructor
   dia_SAFeatureTunerDAB ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTunerDAB ( void );

   //! OPCODE UPREG request
   virtual tDiaResult tunerDAB_attachNotification ( dia_eTunerDABNotification id );
   //! OPCODE RELREG answer
   virtual tDiaResult tunerDAB_detachNotification ( dia_eTunerDABNotification id );

   //----------------------------------------------------------------------
   // Interface dia_ITunerDAB
   //----------------------------------------------------------------------
   //virtual void vOnGetTunerDABTestModeDataInfo ( tU32 dabBitErrRateFIC, tU32 dabBitErrRateMSC ) {}

   //! request detailed test mode data from the DAB module
   virtual tDiaResult tunerDABTestModeData_Get ( void  );
   //! set the mode (active/inactive) of DAB testmode, while active many messages where created which could impact the overall system
   virtual tDiaResult tunerDABTestmode_Set ( tBool state );
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABStatus_Get ( void  );
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABChannelInfo_Get ( void  );
   //! request detailed tuner info about the active ensemble
   virtual tDiaResult tunerDABActiveEnsemleInfo_Get(void);
   //! request detailed tuner info about the active component
   virtual tDiaResult tunerDABActiveComponentInfo_Get(void);
   //! request detailed tuner info about the active service
   virtual tDiaResult tunerDABActiveServiceInfo_Get(void);
   //! request detailed background test mode data from the DAB module
   //virtual tDiaResult tunerDABBGTestModeData_Get (void) {}   
   //! request detailed background test mode data from the DAB module
   virtual tDiaResult tunerDABBGTestModeData_Get (void);  //Kapil 
   //! request detailed tuner status info from EnsemblyFrequency; ServiceID
   virtual tDiaResult tunerDAB_GetStatus ( void  );


protected:
   //! deprecated default constructor
   dia_SAFeatureTunerDAB ( void );

   //--------------------------------------------------------------------------
   // Handlers for incoming messages
   //--------------------------------------------------------------------------

   //! handle incoming CCA message
   void vHandleIOControl ( amt_tclServiceData* poMessage );

   void vHandleTunerDABStatus_Get   ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerDABTestMode_Get ( amt_tclServiceData* poMessage ) ;
   void vHandleTunerDABTestMode_Set ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerDABChannelInfo_Get ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerDABActiveEnsembleInfo_Get (amt_tclServiceData* poMessage) const;
   void vHandleTunerDABActiveComponentInfo_Get(amt_tclServiceData* poMessage) const;
   void vHandleTunerDABActiveServiceInfo_Get  (amt_tclServiceData* poMessage) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTunerDAB)
};

#endif /* DIA_SAFEATURETUNERDAB_H_ */
