/*
 * dia_SAFeatureTunerDAB.cpp
 *
 *  Created on: 20.11.2013
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SAFeatureTunerDAB.h"

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_STDVISITORS
#include "midw_ext_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MAX_UNSIGNED_32BIT_NUMBER (0xFFFFFFFFU)

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerDAB,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS,  vHandleTunerDABStatus_Get  )
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TESTMODE_DATA, vHandleTunerDABTestMode_Get)
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_TESTMODE,  vHandleTunerDABTestMode_Set)
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO,  vHandleTunerDABChannelInfo_Get)
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_ENSEMBLE_INFO,  vHandleTunerDABActiveEnsembleInfo_Get)
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_COMPONENT_INFO, vHandleTunerDABActiveComponentInfo_Get)
   ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO,   vHandleTunerDABActiveServiceInfo_Get)
END_MSG_MAP()

// Link enum and Function ID
static tU16 arTunDabFIDMapping[DIA_EN_TUNERDAB_NOTIFICATION_COUNT] = {
        0xFFFF,
        MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TESTMODE_DATA  // DIA_EN_TUNERDAB_NOTIFICATION_TUNER_AERIAL_DAB1_STATUS
};

//------------------------------------------------------------------------------

dia_SAFeatureTunerDAB::dia_SAFeatureTunerDAB (
      tCString name,// feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
)
: dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::dia_SAFeatureTunerDAB");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTunerDAB::~dia_SAFeatureTunerDAB(void)
{}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTunerDAB::tunerDAB_GetStatus(tVoid)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDAB_GetStatus()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDAB_GetStatus - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDAB_GetStatus - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDAB_GetStatus - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDAB_GetStatus - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDAB_GetStatus - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDAB_attachNotification ( dia_eTunerDABNotification id )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDAB_attachNotification()");
   tDiaResult retCode = DIA_FAILED;

   tU16 fid = arTunDabFIDMapping[id];
   if ( fid != 0xFFFF )
   {
      if ( mpSrvPlugin->bRegisterForFID(fid) ) retCode = DIA_SUCCESS;
   }

   return retCode;
}
//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDAB_detachNotification ( dia_eTunerDABNotification id )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDAB_detachNotification()");
   tDiaResult retCode = DIA_FAILED;

   tU16 fid = arTunDabFIDMapping[id];
   if ( fid != 0xFFFF )
   {
      if ( mpSrvPlugin->bUnregisterForFID(fid) ) retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureTunerDAB::tunerDABBGTestModeData_Get(void)
{
	tDiaResult retCode = DIA_FAILED;
	return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABStatus_Get(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABStatus_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABStatus_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABStatus_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABStatus_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABStatus_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABStatus_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABTestModeData_Get(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABTestModeData_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestModeData_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TESTMODE_DATA,
            CCA_C_U8_OPCODE_UPREG
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestModeData_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestModeData_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestModeData_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestModeData_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - transmitMessage success.");

//         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - CALL RELUPREG.");
//         // unregister for current service - information complete
//         if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
//            DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - send message.");
//            gm_tclEmptyMessage oMessage(
//                  mAppID,
//                  mpSrvPlugin->getClientID(),
//                  mpSrvPlugin->getRegistrationID(),
//                  0,
//                  mpSrvPlugin->getServiceID(),
//                  MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TESTMODE_DATA,
//                  CCA_C_U8_OPCODE_RELUPREG
//            );
//            if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
//               DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - transmitMessage success.");
//            } else {
//               DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - transmitMessage failed.");
//            }
//         } else {
//            DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - getRegistrationID failed.");
//            DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
//         }
//         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - CALL RELUPREG DONE.");

      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABChannelInfo_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABTestmode_Set(tBool state)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABTestmode_Set()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - send message.");

         midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart oData;
         if(state == TRUE){
            DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - state==TRUE -> Mode active.");
         } else {
            DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - state==FALSE -> Mode INactive.");
         }
         oData.bActive = state;

         //put the data in message
         fi_tclVisitorMessage oMessage(oData);
         mpSrvPlugin->vInitServiceData(oMessage, MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_TESTMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - transmitMessage success.");
         } else {
            DIA_TR_ERR("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - transmitMessage failed.");
         }
      } else {
         DIA_TR_ERR("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - getRegistrationID failed.");
         DIA_TR_ERR("dia_SAFeatureTunerDAB::tunerDABTestmode_Set - getRegistrationID == AMT_C_U16_REGID_INVALID.");
      }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_ENSEMBLE_INFO,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveEnsemleInfo_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_COMPONENT_INFO,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveComponentInfo_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get - transmitMessage failed.");
      }

   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::tunerDABActiveServiceInfo_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}
//==========================================================================================================================================
//==========================================================================================================================================

void
dia_SAFeatureTunerDAB::vHandleTunerDABStatus_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABStatus_Get()");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            dia_tTunerDABStatus status;
            // DAB Signal quality
            status.DABSigQuality = oCompResp.TunerStatus.u8SignalQuality;
            DIA_TR_INF("status.DABQuality = 0x%02x / %d .", status.DABSigQuality, status.DABSigQuality );
            // DAB Audio Quality
            status.DABAudQuality = oCompResp.TunerStatus.u8AudioQuality;
            DIA_TR_INF("status.DABAudQuality = 0x%02x / %d .", status.DABAudQuality, status.DABAudQuality );
            // Frequency and Channel Number
            status.frequency = oCompResp.TunerStatus.FreqTuned.u32Frequency;
            status.freqLabel.string = oCompResp.TunerStatus.FreqTuned.sFreqLabel.szValue;
            status.freqLabel.strLen = (tU16) oCompResp.TunerStatus.FreqTuned.sFreqLabel.u32GetSize();
            DIA_TR_INF("status.freqLabel = %s (%d B).", status.freqLabel.string, status.freqLabel.strLen);
            // Ensemble and Component IDs
            status.ensembleID = oCompResp.TunerStatus.u32CurrentEnsembleId;
            status.componentID = oCompResp.TunerStatus.u16CurrentSCIDI;

            pListener->vOnTunerDABStatus(status);

            // ReadDataByIdentifier - DABTuner_1_EnsembleFrequency
            tU32 frequencyInkHz = oCompResp.TunerStatus.FreqTuned.u32Frequency;
            tU32 frequencyInHz = 0;
            DIA_TR_INF("EnsembleFrequency [kHz]: 0x%08x (decimal %d)", frequencyInkHz, frequencyInkHz);

            //check range for possible output (x*1000), 32bit unsigned variable must be enough.
            if (frequencyInkHz>(MAX_UNSIGNED_32BIT_NUMBER/1000))
            {
               DIA_TR_ERR("frequencyInkHz=0x%08X (decimal %d) is bigger than 0x%08X (decimal %d). ERROR!", frequencyInkHz, frequencyInkHz, (MAX_UNSIGNED_32BIT_NUMBER/1000), (MAX_UNSIGNED_32BIT_NUMBER/1000));
            }
            else
            {
               frequencyInHz = (oCompResp.TunerStatus.FreqTuned.u32Frequency) * 1000; // conversion kHz to Hz
               DIA_TR_INF("EnsembleFrequency [Hz]: 0x%08x (decimal %d)", frequencyInHz, frequencyInHz);
            }

            pListener->vOnDABStatusEnsembleFrequency(frequencyInHz);

            // ReadDataByIdentifier - DABTuner_1_ServiceID
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABStatus_Get ServiceId: %d/0x%08x .", oCompResp.TunerStatus.u32CurrentServiceId, oCompResp.TunerStatus.u32CurrentServiceId);
            pListener->vOnDABStatusServiceID(oCompResp.TunerStatus.u32CurrentServiceId);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABStatus_Get - opcode error received with error code:%d", u16ErrorCode);
      }
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABStatus_Get FINISH! ...................................");
      (void) poMessage->bDelete();
   }
}

//------------------------------------------------------------------------------

void
dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get()");

   // Stop sending Testmode data
   tunerDABTestmode_Set(FALSE);

   // unregister/release for current service - information complete
   DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - CALL RELUPREG.");
   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TESTMODE_DATA,
            CCA_C_U8_OPCODE_RELUPREG
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }
   DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - CALL RELUPREG DONE.");


   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            dia_tDABTestModeData testData;
            // DAB Service ID
            testData.m_u32ServiceId = oCompResp.TestModeData.u32CurrentServID;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.m_u32ServiceId = 0x%02x / %d .", testData.m_u32ServiceId, testData.m_u32ServiceId );
            // FM Quality
            testData.FMQuality = oCompResp.TestModeData.u8AltFMQuality;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.FMQuality = 0x%02x / %d .", testData.FMQuality, testData.FMQuality );
            // Service linking status
            switch(oCompResp.TestModeData.e8ServiceLinkingMode.enType){
               case midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::FI_EN_DAB_SERVICELINKING_DAB:
                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.serviceLinkingMode = DIA_EN_TUNERDAB_SRV_LINKING_MODE_DAB .");
                  testData.serviceLinkingMode = DIA_EN_TUNERDAB_SRV_LINKING_MODE_DAB;
                  break;
               case midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::FI_EN_DAB_SERVICELINKING_DAB_FM:
                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.serviceLinkingMode = DIA_EN_TUNERDAB_SRV_LINKING_MODE_FM .");
                  testData.serviceLinkingMode = DIA_EN_TUNERDAB_SRV_LINKING_MODE_FM;
                  break;
               default:
                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get UNKNOWN SRV LINKING MODE %d !", oCompResp.TestModeData.e8ServiceLinkingMode.enType);
                  testData.serviceLinkingMode = DIA_EN_TUNERDAB_SRV_LINKING_MODE_UNKNOWN;
                  break;
            }
            // Field Strength
            testData.m_s8FieldStrength = oCompResp.TestModeData.s8FieldStrength;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.m_s8FieldStrength = 0x%02x / %d .", testData.m_s8FieldStrength, testData.m_s8FieldStrength );
            // Bit Error Rate FIC
            testData.m_u32BERofFIC = oCompResp.TestModeData.u32FICBER;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.m_u32BERofFIC = 0x%08x / %d .", testData.m_u32BERofFIC, testData.m_u32BERofFIC );
            // Bit Error Rate MSC
            testData.m_u32BERofMSC = oCompResp.TestModeData.u32MSCBER;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.m_u32BERofMSC = 0x%08x / %d .", testData.m_u32BERofMSC, testData.m_u32BERofMSC );
            // Extended Country Code
            testData.extCntryCode = oCompResp.TestModeData.u8ECC;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.extCntryCode = 0x%02x / %d .", testData.extCntryCode, testData.extCntryCode );
            // Protection Level
            // testData.protLevel = oCompResp.TestModeData.u8ProtectionLevel;
            // TODO - Matching between u8 and my enumeration

            // Transmission mode
            testData.transmissionMode = oCompResp.TestModeData.u8DABMode;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get testData.transmissionMode = 0x%02x / %d .", testData.transmissionMode, testData.transmissionMode );
            pListener->vOnDABStatusSignalFieldStrengh(testData.m_s8FieldStrength);
            pListener->vOnTunerDABTestModeData(testData);
            pListener->vOnGetTunerDABTestModeDataInfo((oCompResp.TestModeData.u32FICBER), (oCompResp.TestModeData.u32MSCBER));
         }

      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get - opcode error received with error code:%d",u16ErrorCode);
      }

      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Get FINISH! ...................................");
      (void) poMessage->bDelete();
   }
}

//------------------------------------------------------------------------------

void
dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set poMessage OK.");

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

//            switch(oCompResp.e8MethodResult.enType){
//               case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK:
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set FI_EN_DAB_RES_OK.");
//                  pListener->vOnDABStatusSignalQuality(RESULT_NOT_READY, 0, 0);
//                  pListener->vOnDABStatusSignalFieldStrengh(RESULT_NOT_READY, 0);
//                  break;
//               case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_FAILED:
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set FI_EN_DAB_RES_FAILED.");
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set case not covered.");
//                  break;
//               case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_NOT_AVAILABLE:
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set FI_EN_DAB_RES_NOT_AVAILABLE.");
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set case not covered.");
//                  break;
//               case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_INPROCESS:
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set FI_EN_DAB_RES_INPROCESS.");
//                  DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set case not covered.");
//                  break;
//               default:
//                  DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set UNKNOWN METHOD RESULT TYPE!");
//                  break;
//            }

         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR("dia_SAFeatureTunerDAB --- opcode error received with error code: %d",u16ErrorCode);
      } else {
         DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set poMessage->u8GetOpCode() UNKNOWN => CODE==%d!",poMessage->u8GetOpCode());
      }

      (void) poMessage->bDelete();
   } else {
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABTestMode_Set poMessage EMPTY!");
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            dia_tTunerDABChannelInfo info;
            // Mute info
            info.mute = oCompResp.ChannelInfo.bMuted;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get info.mute = 0x%02x / %d .", info.mute, info.mute );
            // Program service identifier
            info.progSrvLabel = oCompResp.ChannelInfo.u32ServId;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get info.progSrvLabel = 0x%02x / %d .", info.progSrvLabel, info.progSrvLabel );
            // Service Label
            info.srvLabel.string = oCompResp.ChannelInfo.ServiceLabel.sLabel.szValue;
            info.srvLabel.strLen = (tU16) oCompResp.ChannelInfo.ServiceLabel.sLabel.u32GetSize();
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get info.progSrvLabel = %s (%d B).", info.srvLabel.string, info.srvLabel.strLen );

            pListener->vOnTunerDABChannelInfo(info);
         }

      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get - opcode error received with error code:%d",u16ErrorCode);
      }
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABChannelInfo_Get FINISH! ...................................");
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            dia_tTunerDABActEnsInfo info;
            // Frequency
            info.frequency = oCompResp.EnsembleInfo.u32Frequency;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get u32Frequency = 0x%08x / %d .", info.frequency, info.frequency );
            // Ensemble ID
            info.ensembleID = oCompResp.EnsembleInfo.u32EnsembleId;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get ensembleID = 0x%08x / %d .", info.ensembleID, info.ensembleID );
            // Ensemble Label
            info.ensembleLabel.string = oCompResp.EnsembleInfo.EnsembleLabel.sLabel.szValue;
            info.ensembleLabel.strLen = (tU16)oCompResp.EnsembleInfo.EnsembleLabel.sLabel.u32GetSize();
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get ensembleID = %s (%d B) .", info.ensembleLabel.string, info.ensembleLabel.strLen );

            pListener->vOnTunerDABActiveEnsembleInfo(info);
         }

      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get - opcode error received with error code:%d",u16ErrorCode);
      }
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveEnsembleInfo_Get FINISH! ...................................");
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTunerDAB::vHandleTunerDABActiveComponentInfo_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABActiveComponentInfo_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            dia_tTunerDABActCompInfo info;
            // Service Component Identifier
            info.serviceCompId = oCompResp.ComponentInfo.u8SCIDS;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveComponentInfo_Get serviceCompId = 0x%02x / %d .", info.serviceCompId, info.serviceCompId );
            // Sub-Channel Identifier
            info.subChannelId = oCompResp.ComponentInfo.u8Subchannel;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveComponentInfo_Get subChannelId  = 0x%02x / %d .", info.subChannelId, info.subChannelId );

            pListener->vOnTunerDABActiveComponentInfo (info);
         }

      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABActiveComponentInfo_Get - opcode error received with error code:%d",u16ErrorCode);
      }
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveComponentInfo_Get FINISH! ...................................");
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ITunerDABListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerDABListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            dia_tTunerDABActSrvInfo info;
            // Data Service Identifier
            info.dataServiceId = oCompResp.ServiceInfo.u32ServId;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get dataServiceId = 0x%02x / %d .", info.dataServiceId, info.dataServiceId );
            // Data Service Label
            info.dataServiceLabel.string = oCompResp.ServiceInfo.ServiceLabel.sLabel.szValue;
            info.dataServiceLabel.strLen = (tU16)oCompResp.ServiceInfo.ServiceLabel.sLabel.u32GetSize();
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get ensembleLabel = %s (%d B) .", info.dataServiceLabel.string, info.dataServiceLabel.strLen );
            // Bit Rate
            info.bitRate = oCompResp.ServiceInfo.u16BitRate;
            DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get dataServiceId = 0x%04x / %d .", info.bitRate, info.bitRate );

            pListener->vOnTunerDABActiveServiceInfo (info);
         }

      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get - opcode error received with error code:%d",u16ErrorCode);
      }
      DIA_TR_INF("dia_SAFeatureTunerDAB::vHandleTunerDABActiveServiceInfo_Get FINISH! ...................................");
      (void) poMessage->bDelete();
   }
}
