/*
 * dia_SAFeatureTouchCntrlReset.cpp
 *
 *  Created on: 22.01.2013
 *      Author: abe6kor
 */
#include "dia_SAFeatureTouchCntrlReset.h"

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTouchCntrlReset,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

#define DIA_ACTIVATE_RESET     0x01
#define DIA_DEACTIVATE_RESET   0x00

//------------------------------------------------------------------------------

dia_SAFeatureTouchCntrlReset::dia_SAFeatureTouchCntrlReset (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTouchCntrlReset::dia_SAFeatureTouchCntrlReset");
}


//-----------------------------------------------------------------------------

dia_SAFeatureTouchCntrlReset::~dia_SAFeatureTouchCntrlReset ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTouchCntrlReset::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY);
   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay ( tU8 extDisplay, dia_eResetTouchCntlExtDisplay mode )
{
    dia_tclFnctTrace trc("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay()");
    tDiaResult retCode = DIA_FAILED;

    tDiaglibParamVector vecRequest;
    trParameter paramResetTC_ControlLine,paramextDisplay;

    paramResetTC_ControlLine.enType = static_cast<tenParameterType>(IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_PARAM2);
    if(mode == DIA_EN_RESETTOUCHCNTLEXTDISPLAY_OFF){
    	paramResetTC_ControlLine.u8Value = DIA_DEACTIVATE_RESET;
       DIA_TR_INF("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay = OFF");
    } else if (mode == DIA_EN_RESETTOUCHCNTLEXTDISPLAY_ON) {
    	paramResetTC_ControlLine.u8Value = DIA_ACTIVATE_RESET;
       DIA_TR_INF("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay = ON");
    } else {
       DIA_TR_ERR("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay - UNKOWN MODE.");
       return retCode;
    }
    DIA_TR_INF("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay - SET EN_ACTION_SET.");

    paramextDisplay.enType = static_cast<tenParameterType>(IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_PARAM1);
    paramextDisplay.u8Value = extDisplay;
    vecRequest.push_back(paramextDisplay);
    vecRequest.push_back(paramResetTC_ControlLine);

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY, EN_ACTION_SET, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay - bIOControlStart - SUCCESS.");
    } else {
       DIA_TR_INF("dia_SAFeatureTouchCntrlReset::setResetTouchCntlExtDisplay - bIOControlStart - FAILED.");
    }

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

void
dia_SAFeatureTouchCntrlReset::vHandleIOControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureTouchCntrlReset::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& /*oStartResult*/)
{
   dia_tclFnctTrace trc("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult()");
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u32IoCtrlId);

   dia_IResetTouchCntlExtDisplayListener* pResetTCControlListener = OSAL_NULL;
   querySysAdapterListener<dia_IResetTouchCntlExtDisplayListener>(&pResetTCControlListener);

   tU8 currEnableMode = 0x00;


   if (pResetTCControlListener)
   {
      tDiaResult ioControlOK = DIA_FAILED;
      if (enResult == EN_IO_CONTROL_OK)
      {
	      DIA_TR_INF("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
	      ioControlOK = DIA_SUCCESS;
      }
      else
      {
          DIA_TR_INF("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
      }

      switch (u32IoCtrlId)
      {
         case IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY:
                    DIA_TR_INF("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY.");
                    if (enResult == EN_IO_CONTROL_OK) {
                       DIA_TR_INF("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
                       pResetTCControlListener->vOnResetTouchController(DIA_SUCCESS);
                    } else {
                       DIA_TR_ERR("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
                       pResetTCControlListener->vOnResetTouchController(DIA_FAILED);
                    }
                    break;
                    default:
                    DIA_TR_ERR("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - u32IoCtrlId = u32IoCtrlId UNKNOWN.");
                    break;
              }

           } else {
              DIA_TR_ERR("dia_SAFeatureTouchCntrlReset::vOnIoCtrlResult - No listener registered");
           }
        }
