/*
 * dia_SAFeatureTCU.h
 *
 *  Created on: 30.11.2015
 *      Author: stc2hi
 */

#ifndef DIA_SAFEATURETCU_H_
#define DIA_SAFEATURETCU_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

// implemented interfaces
#ifndef __INCLUDED_DIA_INTERFACE_TCU_LISTENER__
#include "project/interfaces/dia_ITCUListener.h"
#endif

class amt_tclServiceData;

class dia_SAFeatureTCU
    : public dia_SystemAdapterFeature,
      public dia_ITCU
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureTCU);

public:
    //! default class constructor
    	dia_SAFeatureTCU ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
    //! class destructor
    virtual ~dia_SAFeatureTCU ( void );

    //
    // implementation of the dia_ITCU interface
    //
    // implementation of the getNissanMCANInfo interface
    virtual tDiaResult getConnectionInfo ( void );
	virtual tDiaResult registerForConnectionInfo(void);

	virtual tDiaResult getSoftwareVersion(void);
    virtual tDiaResult registerForSoftwareVersion(void);

    virtual tDiaResult getHardwareVersion(void);
    virtual tDiaResult registerForHardwareVersion(void);

protected:
    //! handle the result of a Connection status message
    tVoid vHandleConnectionState ( amt_tclServiceData* poMessage ) const;
    //! handle the result of a SoftwareVersion status message
    tVoid vHandleSoftwareVersion( amt_tclServiceData* poMessage ) const;
    //! handle the result of a HardwareVersion status message
    tVoid vHandleHardwareVersion( amt_tclServiceData* poMessage ) const;

    tBool bSendMessage (
            const tU8  u8MessageType,
            const tU16 u16FID,
            const tU8  u8Opcode,
            const tU16 u16MsgLength,
            const tU8  u8MsgBuffer[]
            );

    // declare message map data structures
    DECLARE_MSG_MAP(dia_SAFeatureTCU)
};

#endif /* DIA_SAFEATURETCU_H_ */
