/*
 * dia_SAFeatureTCU.cpp
 *
 *  Created on: 30.11.2015
 *      Author: stc2hi
 /*********************************************************************************************
 * HISTORY:
 *------------------------------------------------------------------------------------------------
 * Date | Rev. | Author | Modification
 *-------------------------------------------------------------------------------------------------- -
 *Jan 25, 2017                               nlk1kor             implemented
                                                                 AIVI-38980
                                                                 Working class for the Communication (connection) status
 *-------------------------------------------------------------------------------------------------- -*/


#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_SERVICEINFO
#include "midw_ext_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef DIA_SAFEATURETCU_H_
#include "dia_SAFeatureTCU.h"
#endif

// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTCU, dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_EXT_TCUFI_C_U16_CONNECTION, vHandleConnectionState)
   ON_MESSAGE(MIDW_EXT_TCUFI_C_U16_SOFTWAREVERSION, vHandleSoftwareVersion)
   ON_MESSAGE(MIDW_EXT_TCUFI_C_U16_HARDWAREVERSION, vHandleHardwareVersion)
END_MSG_MAP()


//------------------------------------------------------------------------------

dia_SAFeatureTCU::dia_SAFeatureTCU (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTCU::dia_SAFeatureTCU");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTCU::~dia_SAFeatureTCU ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTCU::getConnectionInfo ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureTCU::getConnectionInfo");

    tDiaResult retCode = DIA_FAILED;

    gm_tclEmptyMessage oMessage (
       mAppID,
       mpSrvPlugin->getClientID(),
       mpSrvPlugin->getRegistrationID(),
       0,
       mpSrvPlugin->getServiceID(),
       MIDW_EXT_TCUFI_C_U16_CONNECTION,
       CCA_C_U8_OPCODE_GET
    );

    if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
    {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureTCU::getConnectionInfo - transmitMessage success.");
    }
    else
    {
       DIA_TR_INF("dia_SAFeatureTCU::getConnectionInfo - transmitMessage failed.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTCU::vHandleConnectionState ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureTCU::vHandleConnectionState");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
            midw_ext_tcufi_tclMsgConnectionStatus oStatusMsgData;
			dia_eTCUConnectionStatusType mCanTcuConnectionStatus ;
            (void) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - Received Connection State");
            DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - Connected = %d", oStatusMsgData.bConnected);
            DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - Absence = 0x%x", oStatusMsgData.u8AbsenceState);
            DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - Mute = 0x%x", oStatusMsgData.u8MuteState);
			DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - CommunicationStatus = %d", oStatusMsgData.e8CommunicationStatus.enType);
			switch (oStatusMsgData.e8CommunicationStatus.enType)
			{
			case midw_ext_fi_tcl_e8_TCU_CommunicationStatus::FI_EN_COMM_STATUS_OFF:
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_OFF");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_OFF;
				break;
			case midw_ext_fi_tcl_e8_TCU_CommunicationStatus::FI_EN_COMM_STATUS_NOT_CONNECTED:
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_NOT_CONNECTED");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_NOT_CONNECTED;
				break;
			case midw_ext_fi_tcl_e8_TCU_CommunicationStatus::FI_EN_COMM_STATUS_CONNECTION_WAIT:
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_CONNECTION_WAIT");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_CONNECTION_WAIT;
				break;
			case midw_ext_fi_tcl_e8_TCU_CommunicationStatus::FI_EN_COMM_STATUS_CONNECTED:
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_CONNECTED");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_CONNECTED;
				break;
			case midw_ext_fi_tcl_e8_TCU_CommunicationStatus::FI_EN_COMM_STATUS_CONNECTION_ERROR:
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_CONNECTION_ERROR");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_CONNECTION_ERROR;
				break;
			case midw_ext_fi_tcl_e8_TCU_CommunicationStatus::FI_EN_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR:
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR;
				break;
			default :
				DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information COMM_STATUS_OFF");
				mCanTcuConnectionStatus = DIA_EN_COMM_STATUS_OFF;
				break;
			}
            dia_ITCUListener* pMCanListener = OSAL_NULL;
            querySysAdapterListener<dia_ITCUListener>(&pMCanListener);
            if ( pMCanListener )
            {
               dia_TCUConnectionInfo nwInfo;

               nwInfo.setAbsentState(oStatusMsgData.u8AbsenceState);
			   nwInfo.setTCUConnectionStatus(mCanTcuConnectionStatus);
			   
			   DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Status = %d", mCanTcuConnectionStatus);
               pMCanListener->vOnConnectionInfo(nwInfo);
               DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - TCU Connection Information forwarded to listener");
            }
            else
            {
            	DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - No TCU listener registered. Discarded!");
            }
        }
        break;

    case AMT_C_U8_CCAMSG_OPCODE_ERROR:
        {
        	DIA_TR_INF("dia_SAFeatureTCU::vHandleConnectionState - Message with opcode error received");
        }
        break;

    default:
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();

}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTCU::registerForConnectionInfo(void)
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::getConnectionInfo");

	tDiaResult retCode = DIA_FAILED;

	gm_tclEmptyMessage oMessage(
		mAppID,
		mpSrvPlugin->getClientID(),
		mpSrvPlugin->getRegistrationID(),
		0,
		mpSrvPlugin->getServiceID(),
		MIDW_EXT_TCUFI_C_U16_CONNECTION,
		CCA_C_U8_OPCODE_UPREG
		);

	if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
	{
		retCode = DIA_SUCCESS;
		DIA_TR_INF("dia_SAFeatureTCU::registerForConnectionInfo - transmitMessage success.");
	}
	else
	{
		DIA_TR_INF("dia_SAFeatureTCU::registerForConnectionInfo - transmitMessage failed.");
	}

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTCU::registerForSoftwareVersion(void)
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::registerForSoftwareVersion");

	tDiaResult retCode = DIA_FAILED;

	gm_tclEmptyMessage oMessage (
	   mAppID,
	   mpSrvPlugin->getClientID(),
	   mpSrvPlugin->getRegistrationID(),
	   0,
	   mpSrvPlugin->getServiceID(),
	   MIDW_EXT_TCUFI_C_U16_SOFTWAREVERSION,
	   CCA_C_U8_OPCODE_UPREG
	);

	if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
	{
	   retCode = DIA_SUCCESS;
	   DIA_TR_INF("dia_SAFeatureTCU::registerForSoftwareVersion - transmitMessage success.");
	}
	else
	{
	   DIA_TR_INF("dia_SAFeatureTCU::registerForSoftwareVersion - transmitMessage failed.");
	}

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTCU::getSoftwareVersion(void)
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::getSoftwareVersion");

	tDiaResult retCode = DIA_FAILED;

	gm_tclEmptyMessage oMessage (
	   mAppID,
	   mpSrvPlugin->getClientID(),
	   mpSrvPlugin->getRegistrationID(),
	   0,
	   mpSrvPlugin->getServiceID(),
	   MIDW_EXT_TCUFI_C_U16_GETSOFTWAREVERSION,
	   CCA_C_U8_OPCODE_METHODSTART
	);

	if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
	{
	   retCode = DIA_SUCCESS;
	   DIA_TR_INF("dia_SAFeatureTCU::getSoftwareVersion - transmitMessage success.");
	}
	else
	{
	   DIA_TR_INF("dia_SAFeatureTCU::getSoftwareVersion - transmitMessage failed.");
	}

	return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTCU::vHandleSoftwareVersion(amt_tclServiceData* poMessage) const
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::vHandleSoftwareVersion");

	// Extract the op code from the message.
	tU8 u8OpCode = poMessage->u8GetOpCode();

	// Switch on the opcode received
	switch (u8OpCode)
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			fi_tclVisitorMessage oStatusMessage(poMessage);
			midw_ext_tcufi_tclMsgSoftwareVersionStatus oStatusMsgData;
			(void) oStatusMessage.s32GetData(oStatusMsgData);

			DIA_TR_INF("dia_SAFeatureTCU::vHandleSoftwareVersion - Received TCU SW version");
			DIA_TR_INF("dia_SAFeatureTCU::vHandleSoftwareVersion - Upper = %d", oStatusMsgData.rSoftwareVersion.u8Upper);
			DIA_TR_INF("dia_SAFeatureTCU::vHandleSoftwareVersion - Mid   = %d", oStatusMsgData.rSoftwareVersion.u8Mid);
			DIA_TR_INF("dia_SAFeatureTCU::vHandleSoftwareVersion - Lower = %d", oStatusMsgData.rSoftwareVersion.u8Lower);

			dia_ITCUListener* pTCUListener = OSAL_NULL;
			querySysAdapterListener<dia_ITCUListener>(&pTCUListener);
			if ( pTCUListener )
			{
				dia_TCUVersionInfo tcuSoftwareVersion;
				tcuSoftwareVersion.m_Upper = oStatusMsgData.rSoftwareVersion.u8Upper;
				tcuSoftwareVersion.m_Mid = oStatusMsgData.rSoftwareVersion.u8Mid;
				tcuSoftwareVersion.m_Lower = oStatusMsgData.rSoftwareVersion.u8Lower;

			    pTCUListener->vOnSoftwareVersion(tcuSoftwareVersion);
			}
			else
			{
				DIA_TR_WRN("dia_SAFeatureTCU::vHandleSoftwareVersion - No TCU listener registered. Discarded!");
			}
		}
		break;

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			DIA_TR_ERR("dia_SAFeatureTCU::vHandleSoftwareVersion - Message with opcode error received");
		}
		break;

	default:
		DIA_TR_ERR("dia_SAFeatureTCU::vHandleSoftwareVersion - Unknown opcode 0x%X received", u8OpCode);
		break;
	}

	// Delete the message we are unable process it at this time
	(tVoid) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTCU::registerForHardwareVersion(void)
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::registerForHardwareVersion");

	tDiaResult retCode = DIA_FAILED;

	gm_tclEmptyMessage oMessage (
	   mAppID,
	   mpSrvPlugin->getClientID(),
	   mpSrvPlugin->getRegistrationID(),
	   0,
	   mpSrvPlugin->getServiceID(),
	   MIDW_EXT_TCUFI_C_U16_HARDWAREVERSION,
	   CCA_C_U8_OPCODE_UPREG
	);

	if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
	{
	   retCode = DIA_SUCCESS;
	   DIA_TR_INF("dia_SAFeatureTCU::registerForHardwareVersion - transmitMessage success.");
	}
	else
	{
	   DIA_TR_INF("dia_SAFeatureTCU::registerForHardwareVersion - transmitMessage failed.");
	}

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureTCU::getHardwareVersion(void)
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::getHardwareVersion");

	tDiaResult retCode = DIA_FAILED;

	gm_tclEmptyMessage oMessage (
	   mAppID,
	   mpSrvPlugin->getClientID(),
	   mpSrvPlugin->getRegistrationID(),
	   0,
	   mpSrvPlugin->getServiceID(),
	   MIDW_EXT_TCUFI_C_U16_GETHARDWAREVERSION,
	   CCA_C_U8_OPCODE_METHODSTART
	);

	if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
	{
	   retCode = DIA_SUCCESS;
	   DIA_TR_INF("dia_SAFeatureTCU::getHardwareVersion - transmitMessage success.");
	}
	else
	{
	   DIA_TR_INF("dia_SAFeatureTCU::getHardwareVersion - transmitMessage failed.");
	}

	return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureTCU::vHandleHardwareVersion(amt_tclServiceData* poMessage) const
{
	dia_tclFnctTrace trc("dia_SAFeatureTCU::vHandleHardwareVersion");

	// Extract the op code from the message.
	tU8 u8OpCode = poMessage->u8GetOpCode();

	// Switch on the opcode received
	switch (u8OpCode)
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			fi_tclVisitorMessage oStatusMessage(poMessage);
			midw_ext_tcufi_tclMsgHardwareVersionStatus oStatusMsgData;
			(void) oStatusMessage.s32GetData(oStatusMsgData);

			DIA_TR_INF("dia_SAFeatureTCU::vHandleHardwareVersion - Received TCU HW version");
			DIA_TR_INF("dia_SAFeatureTCU::vHandleHardwareVersion - Upper = %d", oStatusMsgData.rHardwareVersion.u8Upper);
			DIA_TR_INF("dia_SAFeatureTCU::vHandleHardwareVersion - Mid   = %d", oStatusMsgData.rHardwareVersion.u8Mid);
			DIA_TR_INF("dia_SAFeatureTCU::vHandleHardwareVersion - Lower = %d", oStatusMsgData.rHardwareVersion.u8Lower);

			dia_ITCUListener* pTCUListener = OSAL_NULL;
			querySysAdapterListener<dia_ITCUListener>(&pTCUListener);
			if ( pTCUListener )
			{
				dia_TCUVersionInfo tcuHardwareVersion;
				tcuHardwareVersion.m_Upper = oStatusMsgData.rHardwareVersion.u8Upper;
				tcuHardwareVersion.m_Mid = oStatusMsgData.rHardwareVersion.u8Mid;
				tcuHardwareVersion.m_Lower = oStatusMsgData.rHardwareVersion.u8Lower;

				pTCUListener->vOnHardwareVersion(tcuHardwareVersion);
			}
			else
			{
				DIA_TR_WRN("dia_SAFeatureTCU::vHandleHardwareVersion - No TCU listener registered. Discarded!");
			}
		}
		break;

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			DIA_TR_ERR("dia_SAFeatureTCU::vHandleHardwareVersion - Message with opcode error received");
		}
		break;

	default:
		DIA_TR_ERR("dia_SAFeatureTCU::vHandleHardwareVersion - Unknown opcode 0x%X received", u8OpCode);
		break;
	}

	// Delete the message we are unable process it at this time
	(tVoid) poMessage->bDelete();
}
