/*
 * dia_SAFeatureSwitchCtrl.cpp
 *
 *  Created on: 27.01.2016
 *      Author: stc2hi
 */

#define SWITCHCTRL_FI_S_IMPORT_INTERFACE_SWITCHCTRL_MAINFI_TYPES
#define SWITCHCTRL_FI_S_IMPORT_INTERFACE_SWITCHCTRL_MAINFI_FUNCTIONIDS
#include "switchctrl_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef DIA_SAFEATURESWITCHCTRL_H_
#include "dia_SAFeatureSwitchCtrl.h"
#endif

// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureSwitchCtrl, dia_SystemAdapterFeature)
   ON_MESSAGE(SWITCHCTRL_MAINFI_C_U16_ITCOMMANDER_CONNECTION, vHandleConnectionState)
   ON_MESSAGE(SWITCHCTRL_MAINFI_C_U16_REARSEAT_CONNECTION, vHandleRcsConnectionState)
END_MSG_MAP()


//------------------------------------------------------------------------------

dia_SAFeatureSwitchCtrl::dia_SAFeatureSwitchCtrl (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwitchCtrl::dia_SAFeatureSwitchCtrl");
}

//-----------------------------------------------------------------------------

dia_SAFeatureSwitchCtrl::~dia_SAFeatureSwitchCtrl ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSwitchCtrl::getConnectionInfo ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureSwitchCtrl::getConnectionInfo");

    tDiaResult retCode = DIA_FAILED;

    switchctrl_mainfi_tclMsgITCommander_ConnectionGet oData;

    //put the data in message
    fi_tclVisitorMessage oMessage(oData);
    mpSrvPlugin->vInitServiceData(oMessage, SWITCHCTRL_MAINFI_C_U16_ITCOMMANDER_CONNECTION, AMT_C_U8_CCAMSG_OPCODE_GET);
    if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
    {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureSwitchCtrl::getConnectionInfo - transmitMessage success.");
    }
    else
    {
       DIA_TR_INF("dia_SAFeatureSwitchCtrl::getConnectionInfo - transmitMessage failed.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSwitchCtrl::getRcsConnectionInfo ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSwitchCtrl::getRcsConnectionInfo");

   tDiaResult retCode = DIA_FAILED;

   switchctrl_mainfi_tclMsgRearSeat_ConnectionGet oData;

   //put the data in message
   fi_tclVisitorMessage oMessage(oData);
   mpSrvPlugin->vInitServiceData(oMessage, SWITCHCTRL_MAINFI_C_U16_REARSEAT_CONNECTION, AMT_C_U8_CCAMSG_OPCODE_GET);
   if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureSwitchCtrl::getRcsConnectionInfo - transmitMessage success.");
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSwitchCtrl::getRcsConnectionInfo - transmitMessage failed.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------


tVoid
dia_SAFeatureSwitchCtrl::vHandleConnectionState ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureSwitchCtrl::vHandleConnectionState");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
            switchctrl_mainfi_tclMsgITCommander_ConnectionStatus oStatusMsgData;
            (void) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - Received Connection State");
            DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - Connected = %d", oStatusMsgData.ITCommConnStatus.bIsConnected);
            DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - Absence = 0x%x", oStatusMsgData.ITCommConnStatus.u8AbsenceState);
            DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - Mute = 0x%x", oStatusMsgData.ITCommConnStatus.u8MuteState);

            dia_IITCommanderListener* pListener = OSAL_NULL;
            if ( (querySysAdapterListener<dia_IITCommanderListener>(&pListener) == DIA_SUCCESS) &&  pListener )
            {
               dia_ITCommanderConnectionInfo nwInfo;

               nwInfo.setAbsentState(oStatusMsgData.ITCommConnStatus.u8AbsenceState);

               pListener->vOnConnectionInfo(nwInfo);
               DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - ITCommander Connection Information forwarded to listener");
            }
            else
            {
            	DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - No ITCommander listener registered. Discarded!");
            }
        }
        break;

    case AMT_C_U8_CCAMSG_OPCODE_ERROR:
        {
        	DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleConnectionState - Message with opcode error received");
        }
        break;

    default:
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();

}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
       {
           fi_tclVisitorMessage oStatusMessage(poMessage);
           switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus oStatusMsgData;
           (void) oStatusMessage.s32GetData(oStatusMsgData);

           DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - Received Connection State");
           DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - Connected = %d", oStatusMsgData.RSCConnectionStatus.bIsConnected);
           DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - Absence = 0x%x", oStatusMsgData.RSCConnectionStatus.u8AbsenceState);
           DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - Mute = 0x%x", oStatusMsgData.RSCConnectionStatus.u8MuteState);

           dia_IRearControlSwitchListener* pListener = OSAL_NULL;
           if ( (querySysAdapterListener<dia_IRearControlSwitchListener>(&pListener) == DIA_SUCCESS) &&  pListener )
           {
              dia_RcsConnectionInfo nwInfo;

              nwInfo.setAbsentState(oStatusMsgData.RSCConnectionStatus.u8AbsenceState);

              pListener->vOnConnectionInfo(nwInfo);
              DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - RCS Connection Information forwarded to listener");
           }
           else
           {
              DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - No RearControlSwitch listener registered. Discarded!");
           }
       }
       break;

   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
       {
        DIA_TR_INF("dia_SAFeatureSwitchCtrl::vHandleRcsConnectionState - Message with opcode error received");
       }
       break;

   default:
       break;
   }

   // Delete the message we are unable process it at this time
   (tVoid) poMessage->bDelete();
}
