/*!
 * \file       dia_SAFeatureSubsystemDiagnosis.h
 *
 * \brief      SystemAdapter to implement the Subsystem Diagnosis Proxy.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaSystemAdapter
 *
 * \copyright  (c) 2020 RBEI
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_SUBSYSTEM_DIAGNOSIS__
#define __INCLUDED_DIA_SAFEATURE_SUBSYSTEM_DIAGNOSIS__

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_SUBSYSTEMDIAGNOSISCLIENTBASE_H
#include <org/bosch/cm/diagnosis/dbus/SubsystemDiagnosisClientBase.h>
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY_LISTENER__
#include <project/interfaces/dia_ISubsystemDiagnosisProxyListener.h>
#endif

using namespace org::bosch::cm::diagnosis::dbus::SubsystemDiagnosis;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSubsystemDiagnosis
   : public dia_SystemAdapterFeatureASF<SubsystemDiagnosisProxy>,
     public SubsystemDiagnosisClientBase,
     public dia_ISubsystemDiagnosisProxy
{
public:
   //! constructor
   dia_SAFeatureSubsystemDiagnosis (dia_SystemAdapterServicePluginASF<SubsystemDiagnosisProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSubsystemDiagnosis();

   //-------------------------------------------------------------------------
   //
   // Overridden dia_ISubsystemDiagnosisProxy methods
   //
   //-------------------------------------------------------------------------
    virtual tDiaResult vStartUdpBroadcastClient ( void ) override;
    virtual tDiaResult vBroadcastVehIdRequest ( void ) override;
    virtual tDiaResult vBroadcastVehIdResults ( void ) override;
    virtual tDiaResult vAvdeccFilesDeleteRequest ( void ) override;

   //-------------------------------------------------------------------------
   //
   // Overridden SubsystemDiagnosisClientBase methods
   //
   //-------------------------------------------------------------------------

   //! CalibrationCallbackIF
   virtual void onStartUDPBroadcastClientError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< StartUDPBroadcastClientError >& error) override;
   virtual void onStartUDPBroadcastClientResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< StartUDPBroadcastClientResponse >& response) override;
	
   virtual void onDiscoverEntitiesResultsError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< DiscoverEntitiesResultsError >& error) override;
   virtual void onDiscoverEntitiesResultsResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< DiscoverEntitiesResultsResponse >& response) override;

   virtual void onAvdeccFilesDeleteError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< AvdeccFilesDeleteError >& error) override;
   virtual void onAvdeccFilesDeleteResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< AvdeccFilesDeleteResponse >& response) override;

protected:
   //! to have an ASF thread synchronization
   void onStartUDPBroadcastClientResponse(tDiaResult result);
   void onDiscoverEntitiesResultsResponse(tDiaResult result, ::std::vector< DiscoverEntitiesResultsResponseNodeListStruct > nodeList);
   void onAvdeccFilesDeleteResponse(tDiaResult result);

   //! deprecated default constructor
   dia_SAFeatureSubsystemDiagnosis ();
};

#endif /* __INCLUDED_DIA_SAFEATURE_SUBSYSTEM_DIAGNOSIS__ */
